package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;

/**
 *
 */
@Annotate
@FromSDK
public class ConferenceStateEvent {

    @NonNull
    public ConferenceState state = ConferenceState.DEFAULT;

    @Nullable
    public Conference conference;

    @Nullable
    public String conferenceAlias;

    public ConferenceStateEvent(@Nullable String conferenceAlias, @NonNull ConferenceState state) {
        this.conferenceAlias = conferenceAlias;
        this.state = state;
    }

    public ConferenceStateEvent(@NonNull Conference conference, @NonNull ConferenceState state) {
        this.conference = conference;
        this.conferenceAlias = conference.getAlias();
        this.state = state;
    }
}
