package com.voxeet.sdk.events.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.events.BaseEvent;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromRestAPI;

import java.util.ArrayList;
import java.util.List;

@Annotate
@FromRestAPI
public class ConferenceStatusResult extends BaseEvent {

    @Nullable
    public String conferenceId;

    @Nullable
    public String conferenceAlias;

    public long startTimestamp;

    public boolean isLive;

    @Nullable
    public String type;

    @Nullable
    public List<SdkParticipant> participants;

    public List<ConferenceUser> getConferenceUsers() {
        List<ConferenceUser> users = new ArrayList<>();
        try {
            if (null != participants) {
                for (SdkParticipant participant : participants) {
                    ConferenceUser user = new ConferenceUser(participant.getUserId(),
                            null,
                            new com.voxeet.sdk.json.UserInfo(
                                    participant.getMetadata().getExternalName(),
                                    participant.getMetadata().getExternalId(),
                                    participant.getMetadata().getExternalPhotoUrl()
                            )
                    );
                    user.setConferenceStatusToString(participant.getStatus());
                    user.setStatus(participant.getStatus());
                    user.setConferenceStatus(ConferenceUserStatus.valueOf(participant.getStatus()));
                    users.add(user);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return users;
    }

    @NonNull
    @Override
    public String getType() {
        return null != type ? type : "";
    }
}
