package com.voxeet.sdk.core.services.presentation.file;

import android.support.annotation.NonNull;

import com.voxeet.sdk.core.services.presentation.PresentationState;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Class representation information about a given File Presentation
 * <p>
 * This class is intended to make very easy to keep track of the various File Presentation that are into a conference
 * and to get the following :
 * <p>
 * - the File Presentation key
 * - the original url used by this presentation
 * - the current state of the Presentation
 */
@Annotate
public class FilePresentation {

    /**
     * Represent the unique key for the presentation. This must be treated as a Primary key to differentiate presentations.
     */
    public final String key;

    /**
     * The url to manipulate the presentation
     * <p>
     * only passed normally hen the presentation is started. This way developers can track and manage the lifecycle
     */
    public final String url;

    /**
     * The current state of the presentation, represents exactly the same states that the presentations can be manipulate with
     */
    public PresentationState state;

    /**
     * The current page
     */
    public int page;
    public int nbPage;

    @NoDocumentation
    private FilePresentation() {
        key = "";
        url = "";
        page = 0;
    }

    @NoDocumentation
    public FilePresentation(@NonNull String key, @NonNull String url) {
        this.key = key;
        this.url = url;
        page = 0;
    }

    @NoDocumentation
    public FilePresentation clone() {
        FilePresentation information = new FilePresentation(key, url);
        information.state = state;
        return information;
    }
}
