package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import java.io.IOException;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class StopRecordingPromiseable extends AbstractPromiseable<Boolean> {

    public StopRecordingPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                try {
                    ConferenceInformation information = getInformation();
                    if (null == information || null == information.getConference().getId()) {
                        throw new NotInConferenceException();
                    }

                    final Call<ResponseBody> user = getProvider().getStopRecordingObservable(information.getConference().getId());
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>() {
                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200)
                                log("Conference recording stopped");

                            try {
                                log("onNext: " + response.body().string());
                            } catch (IOException e) {
                                e.printStackTrace();
                            }

                            solver.resolve(response.code() == 200);
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);

                            log("Failed to cancel mConference recording");

                            solver.reject(e);
                        }
                    });
                } catch (Throwable e) {
                    e.printStackTrace();
                    solver.reject(e);
                }
            }
        });
    }
}
