package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class SendBroadcastMessagePromise extends AbstractPromiseable<Boolean> {

    private final String message;
    private final String conferenceId;

    public SendBroadcastMessagePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus,
                                       @NonNull String conferenceId,
                                       @NonNull String message) {
        super(parent, mediaDeviceService, provider, information, eventBus);

        this.conferenceId = conferenceId;
        this.message = message;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                try {
                    if (null == conferenceId) {
                        throw new NotInConferenceException();
                    }
                } catch (NotInConferenceException exception) {
                    solver.reject(exception);
                    return;
                }

                final Call<ResponseBody> user = getProvider().broadcastMessage(conferenceId, new BroadcastEvent(message));
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>() {
                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        log("The broadcast message has been sent");

                        //getEventBus().post(new SendBroadcastResultEvent(response.code() == 200));
                        solver.resolve(true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);

                        log("The broadcast message has not been sent");

                        //getEventBus().post(new SendBroadcastResultEvent(false));
                        solver.resolve(false);
                    }
                });
            }
        });
    }
}
