package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.GetConferenceHistoryErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.sdk.GetConferenceHistoryResult;
import com.voxeet.sdk.models.v1.HistoryConference;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceHistoryPromiseable extends AbstractPromiseable<GetConferenceHistoryResult> {

    public GetConferenceHistoryPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<GetConferenceHistoryResult> createPromise() {
        return new Promise<>(new PromiseSolver<GetConferenceHistoryResult>() {
            @Override
            public void onCall(@NonNull final Solver<GetConferenceHistoryResult> solver) {
                final Call<List<HistoryConference>> user = getProvider().getConferenceHistoryObservable(getInformation().getConference().getId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<List<HistoryConference>>() {
                    @Override
                    public void onSuccess(@NonNull List<HistoryConference> object, @NonNull Response<List<HistoryConference>> response) {
                        log("Dispatching mConference history response");

                        solver.resolve(new GetConferenceHistoryResult(object));
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<List<HistoryConference>> response) {
                        HttpException.dumpErrorResponse(response);

                        log("Error while retrieving mConference history");

                        getEventBus().post(new GetConferenceHistoryErrorEvent(getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}
