/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.exceptions;

import android.support.annotation.NonNull;
import com.voxeet.sdk.exceptions.ExceptionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ExceptionManager {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final List<ExceptionListener> listeners = new ArrayList<ExceptionListener>();

    private ExceptionManager() {
    }

    public static void register(@NonNull ExceptionListener listener) {
        ExceptionManager.lock();
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
        ExceptionManager.unlock();
    }

    public static void unregister(@NonNull ExceptionListener listener) {
        ExceptionManager.lock();
        listeners.remove(listener);
        ExceptionManager.unlock();
    }

    public static void sendException(@NonNull Throwable throwable) {
        ExceptionManager.lock();
        for (ExceptionListener listener : listeners) {
            try {
                listener.onException(throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ExceptionManager.unlock();
    }

    private static void lock() {
        try {
            if (!lock.isLocked()) {
                lock.lock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void unlock() {
        try {
            if (lock.isLocked()) {
                lock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

