/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.promises.StartRecordingPromiseable;
import com.voxeet.sdk.core.services.conference.promises.StopRecordingPromiseable;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.json.RecordingStatusUpdateEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;
import java.util.Date;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Annotate
public class RecordingService
extends AbstractVoxeetService<ISdkConferenceRService> {
    private static final String TAG = RecordingService.class.getSimpleName();
    private ConferenceSdkObservableProvider mConferenceObservableProvider = new ConferenceSdkObservableProvider();
    private boolean isRecording = false;
    private Context mContext;
    private boolean isICERestartEnabled = false;

    @NoDocumentation
    public RecordingService(VoxeetSdk instance, long timeout) {
        super(instance, new ServiceProviderHolder.Builder().setRetrofit(instance.getRetrofit()).setService(ISdkConferenceRService.class).setEventBus(instance.getEventBus()).setClient(instance.getClient()).build());
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider((ISdkConferenceRService)this.getService());
        this.mContext = instance.getApplicationContext();
        this.registerEventBus();
    }

    public void toggleRecording() {
        Promise<Boolean> promise = this.isRecording ? this.stopRecording() : this.startRecording();
        promise.then(new PromiseExec<Boolean, Object>(){

            @Override
            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggle done " + result));
            }
        }).error(new ErrorPromise(){

            @Override
            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    public Promise<Boolean> startRecording() {
        ConferenceService service = VoxeetSdk.conference();
        return new StartRecordingPromiseable(service, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, service.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> stopRecording() {
        ConferenceService service = VoxeetSdk.conference();
        return new StopRecordingPromiseable(service, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, service.getCurrentConferenceInformation(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(RecordingStatusUpdateEvent recordingStatusUpdateEvent) {
        ConferenceService service = VoxeetSdk.conference();
        if (null == service) {
            return;
        }
        String conferenceId = recordingStatusUpdateEvent.conferenceId;
        ConferenceInformation information = service.getConferenceInformation(conferenceId);
        if (null == information) {
            return;
        }
        Conference conference = information.getConference();
        User user = service.findUserById(recordingStatusUpdateEvent.userId);
        if (user != null) {
            Conference.RecordingInformation recording = new Conference.RecordingInformation();
            RecordingStatus status = RecordingStatus.valueOf(recordingStatusUpdateEvent.recordingStatus);
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                recording.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.timeStamp));
                recording.setRecordingStatus(RecordingStatus.RECORDING);
                recording.setRecordingUser(recordingStatusUpdateEvent.userId);
            } else {
                this.isRecording = false;
                recording.setStartRecordTimestamp(null);
                recording.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                recording.setRecordingUser(null);
            }
            conference.setRecordingInformation(recording);
        }
    }
}

