/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.utils.EventCallback;
import com.voxeet.sdk.core.VoxeetEnvironmentHolder;
import com.voxeet.sdk.core.VoxeetSdkFactory;
import com.voxeet.sdk.core.VoxeetSdkTemplate;
import com.voxeet.sdk.core.impl.ConferenceSdkService;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.LocalStatsService;
import com.voxeet.sdk.core.services.MediaService;
import com.voxeet.sdk.core.services.SDKFilePresentationService;
import com.voxeet.sdk.core.services.SDKVideoPresentationService;
import com.voxeet.sdk.core.services.ScreenShareService;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.core.services.authenticate.token.RefreshTokenCallback;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;

public final class VoxeetSdk
extends VoxeetSdkTemplate<ConferenceSdkService> {
    private static Application CurrentApplication = null;
    private static VoxeetSdk CurrentInstance;
    private static final String TAG;

    protected static void setInstance(@NonNull VoxeetSdk sdk) {
        CurrentInstance = sdk;
    }

    public static VoxeetSdk getInstance() {
        return CurrentInstance;
    }

    public static void setApplication(@NonNull Application application) {
        CurrentApplication = application;
    }

    public static synchronized void initialize(@NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        VoxeetSdk.initialize(CurrentApplication, appId, password, userInfo);
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(application, appId, password, userInfo);
            VoxeetSdk.setInstance(sdk);
            VoxeetSdkFactory.validate((VoxeetSdkTemplate)sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull Application application, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @NonNull UserInfo userInfo) {
        if (null == CurrentInstance) {
            VoxeetSdk sdk = new VoxeetSdk(application, accessToken, refreshToken, userInfo);
            VoxeetSdk.setInstance(sdk);
            VoxeetSdkFactory.validate((VoxeetSdkTemplate)sdk);
        } else {
            Log.d((String)TAG, (String)"initialize: Instance already started !");
        }
    }

    public static synchronized void initialize(@NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @NonNull UserInfo userInfo) {
        VoxeetSdk.initialize(CurrentApplication, accessToken, refreshToken, userInfo);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo) {
        super(application_context, appId, password, userInfo, (AbstractVoxeetEnvironmentHolder)new VoxeetEnvironmentHolder((Context)application_context), false);
    }

    private VoxeetSdk(@NonNull Application application_context, @NonNull String accessToken, @NonNull RefreshTokenCallback refreshToken, @NonNull UserInfo userInfo) {
        super(application_context, accessToken, refreshToken, userInfo, (AbstractVoxeetEnvironmentHolder)new VoxeetEnvironmentHolder((Context)application_context), false);
    }

    public Promise<Boolean> logout() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)"onCall: logout called");
                VoxeetSdk.this.onLogoutCleanLoginSockets();
                Log.d((String)TAG, (String)"onCall: clean awaiting sockets done");
                ((ConferenceSdkService)VoxeetSdk.this.getConferenceService()).logout().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> s) {
                        Log.d((String)TAG, (String)("onCall: logout result := " + result + " ... propagating..."));
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    public void onSdkPreinit() {
    }

    protected void initServices() {
        this.getServices().put(ConferenceSdkService.class, new ConferenceSdkService((VoxeetSdkTemplate)this, 60000L));
        this.getServices().put(UserService.class, new UserService((VoxeetSdkTemplate)this));
        this.getServices().put(SDKFilePresentationService.class, new SDKFilePresentationService((VoxeetSdkTemplate)this));
        this.getServices().put(SDKVideoPresentationService.class, new SDKVideoPresentationService((VoxeetSdkTemplate)this));
        this.getServices().put(AudioService.class, new AudioService((VoxeetSdkTemplate)this));
        this.getServices().put(ScreenShareService.class, new ScreenShareService((VoxeetSdkTemplate)this));
        this.getServices().put(MediaService.class, new MediaService((VoxeetSdkTemplate)this));
        this.getServices().put(LocalStatsService.class, new LocalStatsService((VoxeetSdkTemplate)this));
    }

    public UserService getUserService() {
        return (UserService)this.getServiceForKlass(UserService.class);
    }

    public SDKFilePresentationService getFilePresentationService() {
        return (SDKFilePresentationService)this.getServiceForKlass(SDKFilePresentationService.class);
    }

    public SDKVideoPresentationService getVideoPresentationService() {
        return (SDKVideoPresentationService)this.getServiceForKlass(SDKVideoPresentationService.class);
    }

    protected String getTag() {
        return VoxeetSdk.class.getSimpleName();
    }

    public void registerEventCallback(EventCallback callback) {
        callback.register((VoxeetSdkTemplate)this);
    }

    static {
        TAG = VoxeetSdk.class.getSimpleName();
    }
}

