package com.voxeet.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

import com.voxeet.sdk.models.Email;
import com.voxeet.sdk.models.abs.UserProfile;

/**
 * Created by RomainB on 5/12/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultUserProfile implements UserProfile {
    private String firstName;

    private String lastName;

    private String nickName;

    private String callLocalPart;

    private boolean editable;

    private String profileType;

    private String userId;

    private String email;

    private String photoId;

    private String statusPhrase;

    private String country;

    private String city;

    private String company;

    private String jobTitle;

    private String presenceStatus;

    private List<Email> emails;

    private List<String> tags;

    private boolean isPro;

    @Override
    public boolean isPro() { return isPro; }

    public void setPro(boolean pro) { isPro = pro; }

    @Override
    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    @Override
    public String getCallLocalPart() {
        return callLocalPart;
    }

    public void setCallLocalPart(String callLocalPart) {
        this.callLocalPart = callLocalPart;
    }

    @Override
    public boolean isEditable() {
        return editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public List<Email> getEmails() {
        return emails;
    }

    public void setEmails(List<Email> emails) {
        if (emails != null && (this.emails == null || this.emails.size() < emails.size())) {
            this.emails = emails;
        }
    }

    @Override
    public List<String> getTags() {
        if (tags == null)
            return null;

        List<String> list = new ArrayList<>();
        list.addAll(tags);
        return list;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public String getProfileType() {
        return profileType;
    }

    public void setProfileType(String profileType) {
        this.profileType = profileType;
    }

    @Override
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getPhotoId() {
        return photoId;
    }

    public void setPhotoId(String photoId) {
        this.photoId = photoId;
    }

    @Override
    public String getStatusPhrase() {
        return statusPhrase;
    }

    public void setStatusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
    }

    @Override
    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Override
    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    @Override
    public String getPresenceStatus() {
        return presenceStatus;
    }

    //TODO reminiscence from RealmObject isValid() - remove ?
    @Override
    public boolean isObjectValid() {
        return true;
    }

    public void setPresenceStatus(String presenceStatus) {
        if (presenceStatus != null) {
            this.presenceStatus = presenceStatus;
        }
    }

    //TODO check for usability of such method ?
    /*private UpdateProfileEvent updateProfileEvent() {
        return new UpdateProfileEvent(
                getUserId(),
                getFirstName(),
                getLastName(),
                getNickName(),
                getStatusPhrase(),
                getJobTitle(),
                getCountry(),
                getCity(),
                getCompany());
    }*/

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        UserProfile profile = (DefaultUserProfile) obj;
        return profile.getUserId().equals(userId);
    }

    public void addEmails(List<Email> emails) {
        if (this.emails == null)
            this.emails = new ArrayList<>();

        this.emails.clear();

        this.emails.addAll(emails);
    }

    @Override
    public String toString() {
        return "DefaultUserProfile{" +
                "userId='" + userId + '\'' +
                '}';
    }
}
