package com.voxeet.sdk.models.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import com.voxeet.sdk.models.abs.Contact;
import com.voxeet.sdk.models.abs.UserProfile;

/**
 * Created by romainbenmansour on 28/06/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DefaultContact implements Contact {

    private String contactId;

    private DefaultUserProfile profile;

    public DefaultContact() {
        this.profile = null;
    }

    public DefaultContact(DefaultUserProfile profile) {
        setProfile(profile);
    }

    public void setProfile(DefaultUserProfile profile) {
        this.profile = profile;
        this.contactId = profile.getUserId();
    }

    @Override
    public UserProfile getProfile() {
        return profile;
    }

    @Override
    public String getContactId() {
        return contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    /*@Override
    public void assignTags(List<String> tags) {
        VoxeetSdk.addTags(contactId, tags);
    }*/
}
