/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.Participant;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Annotate
public class Conference {
    private static final String TAG = "Conference";
    @NonNull
    private String id = "";
    @Nullable
    private String alias;
    @NonNull
    private CopyOnWriteArrayList<User> users = new CopyOnWriteArrayList();
    @Nullable
    private User mixer;
    @Nullable
    private ConferenceInfos conferenceInfos;
    @Nullable
    private RecordingInformation recordingInformation;

    @NoDocumentation
    public Conference() {
    }

    @NoDocumentation
    public Conference(com.voxeet.sdk.models.v1.Conference fromConference) {
        this();
        this.updateUsers(fromConference.getConferenceUsers());
        this.id = fromConference.getConferenceId();
        this.alias = fromConference.getConferenceAlias();
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @NonNull
    public CopyOnWriteArrayList<User> getUsers() {
        return this.users;
    }

    public boolean hasAny(ConferenceUserStatus status, boolean local) {
        String id = VoxeetSdk.user().getUserId();
        if (null == id) {
            id = "";
        }
        for (User user : this.users) {
            if (null == user || !status.equals((Object)user.getStatus()) || id.equals(user.getId())) continue;
            return true;
        }
        return false;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUsers(ConferenceUser user) {
        User internalUser = this.getInternalUserInConference(user);
        if (null == internalUser) {
            Log.d((String)TAG, (String)("updateUsers: create User from ConferenceUser := " + new User(user)));
            this.addUser(new User(user));
        } else {
            internalUser.updateStatus(user.getConferenceStatus());
        }
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUser(@NonNull Participant participant) {
        User internalUser = this.getInternalUserInConference(participant);
        if (null == internalUser) {
            Log.d((String)TAG, (String)("updateUsers: create User from Participant := " + new User(participant)));
            String externalId = participant.getExternalId();
            User existing = this.findUserByExternalId(externalId);
            if (null != existing) {
                Log.d((String)TAG, (String)"updateUser: existing user, updating hi\u00b7er");
                existing.updateIfNeeded(participant.getName(), participant.getAvatarUrl());
            } else {
                Log.d((String)TAG, (String)"updateUser: new user, adding hi\u00b7er");
                this.addUser(new User(participant));
            }
        } else {
            internalUser.updateStatus(ConferenceUserStatus.fromString(participant.getStatus()));
        }
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUser(User user) {
        User internalUser = this.getInternalUserInConference(user);
        if (null == internalUser) {
            Log.d((String)"ConferenceService", (String)("updateUsers: create User from User := " + user));
            this.addUser(user);
        } else {
            internalUser.updateStatus(user.getStatus());
        }
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUsers(List<ConferenceUser> users) {
        try {
            for (ConferenceUser user : users) {
                this.updateUsers(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateParticipants(List<Participant> participants) {
        try {
            for (Participant participant : participants) {
                this.updateUser(participant);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Nullable
    private User getInternalUserInConference(ConferenceUser user) {
        try {
            int index = this.users.indexOf(user);
            if (index >= 0) {
                return this.users.get(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private User getInternalUserInConference(User user) {
        try {
            int index = this.users.indexOf(user);
            if (index >= 0) {
                return this.users.get(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private User getInternalUserInConference(Participant user) {
        try {
            int index = this.users.indexOf(user);
            if (index >= 0) {
                return this.users.get(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @NoDocumentation
    public Conference setConferenceId(@NonNull String id) {
        this.id = id;
        return this;
    }

    @NoDocumentation
    public Conference setConferenceAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public boolean hasMixer() {
        return null != this.mixer && ConferenceUserStatus.ON_AIR.equals((Object)this.mixer.getStatus());
    }

    private boolean isMixer(@NonNull User user) {
        UserInfo userInfo = user.getUserInfo();
        String userName = null != userInfo ? userInfo.getName() : null;
        return null != userName && "Mixer".equalsIgnoreCase(userName.trim());
    }

    @Nullable
    public User findUserById(@Nullable String userId) {
        if (null == userId) {
            return null;
        }
        for (User user : this.users) {
            if (!userId.equals(user.getId())) continue;
            return user;
        }
        UserService userService = VoxeetSdk.user();
        if (null == userService) {
            return null;
        }
        String localUserId = userService.getUserId();
        if (null != localUserId && localUserId.equals(userId)) {
            Log.d((String)TAG, (String)"findUserById: user not found but local one, creating a TEMP ONE ONLY");
            return userService.getUser();
        }
        return null;
    }

    @Nullable
    public User findUserByExternalId(@Nullable String externalId) {
        if (null == externalId) {
            return null;
        }
        for (User user : this.users) {
            UserInfo userInfo = user.getUserInfo();
            if (null == userInfo || !externalId.equals(userInfo.getExternalId())) continue;
            return user;
        }
        return null;
    }

    @NoDocumentation
    public void setConferenceInfos(@NonNull ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Nullable
    public ConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    @NoDocumentation
    public void setRecordingInformation(@Nullable RecordingInformation recordingInformation) {
        this.recordingInformation = recordingInformation;
    }

    @Nullable
    public RecordingInformation getRecordingInformation() {
        return this.recordingInformation;
    }

    private void addUser(@NonNull User user) {
        if (this.isMixer(user)) {
            this.mixer = user;
        } else {
            this.users.add(user);
        }
    }

    public static class RecordingInformation {
        private Date startRecordTimestamp;
        private RecordingStatus recordingStatus;
        private String recordingUser;

        public void setStartRecordTimestamp(Date startRecordTimestamp) {
            this.startRecordTimestamp = startRecordTimestamp;
        }

        public Date getStartRecordTimestamp() {
            return this.startRecordTimestamp;
        }

        public void setRecordingStatus(RecordingStatus recordingStatus) {
            this.recordingStatus = recordingStatus;
        }

        public RecordingStatus getRecordingStatus() {
            return this.recordingStatus;
        }

        public void setRecordingUser(String recordingUser) {
            this.recordingUser = recordingUser;
        }

        public String getRecordingUser() {
            return this.recordingUser;
        }
    }
}

