/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.network.websocket;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetDispatcher;
import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.websocket.SocketListener;
import com.voxeet.sdk.core.network.websocket.WebSocketProxy;
import com.voxeet.sdk.core.services.authenticate.WebSocketState;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import okhttp3.WebSocket;

public class VoxeetWebSocket {
    private static final String TAG = VoxeetWebSocket.class.getSimpleName();
    private AbstractVoxeetEnvironmentHolder environment_holder;
    public static final String SOCKET_ERROR = "SOCKET_ERROR";
    public static final String SOCKET_MESSAGE = "SOCKET_TEXT";
    public static final String SOCKET_CONNECTED = "SOCKET_CONNECTED";
    public static final String SOCKET_DISCONNECTED = "SOCKET_DISCONNECTED";
    public static final String SOCKET_STATE_CHANGE = "SOCKET_STATE_CHANGE";
    private String socketUrl;
    private WebSocketProxy mWebSocketProxy;
    private SocketListener listener = new SocketListener(){

        @Override
        public void onConnect(WebSocket webSocket) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_CONNECTED, "Connected");
        }

        @Override
        public void onTextMessage(String message) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_MESSAGE, message);
        }

        @Override
        public void onError(HttpException exception) {
            exception.printStackTrace();
            if (null != exception.getResponse()) {
                try {
                    Log.d((String)TAG, (String)("onError: http exception for socket (message) " + exception.getResponse().message()));
                    Log.d((String)TAG, (String)("onError: http exception for socket (body) " + exception.getResponse().body().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_ERROR, "Error " + exception.getMessage());
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onStateChanged(WebSocketState newState) {
            Log.d((String)TAG, (String)("onStateChanged: newState:=" + (Object)((Object)newState)));
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_STATE_CHANGE, newState.name());
        }

        @Override
        public void onDisconnected() {
            Log.d((String)TAG, (String)"Websocket disconnect by server");
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_DISCONNECTED, "on Disconnected by server: ");
        }
    };

    public VoxeetWebSocket(VoxeetSdk sdk, @NonNull String socketUrl) {
        this.environment_holder = sdk.getVoxeetEnvironmentHolder();
        this.socketUrl = socketUrl;
    }

    public void connect(@NonNull VoxeetHttp provider) {
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.removeListeners();
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
        }
        this.createProxy();
        this.mWebSocketProxy.connect(provider, null);
    }

    private void clear() {
        VoxeetDispatcher.dispatch(SOCKET_STATE_CHANGE, WebSocketState.CLOSED.name());
        if (null != this.mWebSocketProxy) {
            this.mWebSocketProxy.cancel();
            this.mWebSocketProxy.disconnect();
            this.mWebSocketProxy.removeListener(this.listener);
            this.mWebSocketProxy.removeListeners();
        }
        this.mWebSocketProxy = null;
    }

    private void createProxy() {
        this.mWebSocketProxy = new WebSocketProxy(this.socketUrl, this.environment_holder.getVersionName());
        this.mWebSocketProxy.addListener(this.listener);
    }

    public void close(boolean set_disconnect) {
        this.clear();
    }

    public boolean isOpen() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }

    private boolean sendPing() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.sendPing();
    }

    public boolean isInit() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }
}

