/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.core.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.ReplayConferenceErrorEvent;
import com.voxeet.sdk.events.restapi.ReplayConferenceResult;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class ReplayPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = ReplayPromise.class.getSimpleName();
    private final String conferenceId;
    private final long offset;

    public ReplayPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId, long offset) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceId = conferenceId;
        this.offset = offset;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                final ConferenceInformation information = ReplayPromise.this.getConferenceInformation(ReplayPromise.this.conferenceId);
                information.setConferenceUserType(ConferenceUserType.LISTENER);
                Call<ReplayConferenceResult> user = ReplayPromise.this.getProvider().getReplayObservable(ReplayPromise.this.conferenceId, new SdkConferenceReplayBody(ReplayPromise.this.offset));
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ReplayConferenceResult>(){

                    @Override
                    public void onSuccess(@NonNull ReplayConferenceResult object, @NonNull Response<ReplayConferenceResult> response) {
                        Log.d((String)TAG, (String)("Success server answer for replaying mConference with id: " + ReplayPromise.this.conferenceId + "at offset: " + ReplayPromise.this.offset + " given := " + object.conferenceId + " " + object.conferenceAlias + " " + information));
                        ReplayPromise.this.moveConference(object.conferenceId, information);
                        information.getConference().setConferenceId(object.conferenceId);
                        information.getConference().setConferenceAlias(object.conferenceAlias);
                        information.setConferenceType(LocalConferenceType.REPLAY);
                        ReplayPromise.this.joinConference(information).then(new PromiseExec<Boolean, Object>(){

                            @Override
                            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                solver.resolve(result);
                            }
                        }).error(new ErrorPromise(){

                            @Override
                            public void onError(Throwable error) {
                                error.printStackTrace();
                                solver.resolve(false);
                            }
                        });
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ReplayConferenceResult> response) {
                        HttpException.dumpErrorResponse(response);
                        Log.d((String)TAG, (String)"Failed to replay mConference");
                        ReplayPromise.this.getEventBus().post((Object)new ReplayConferenceErrorEvent(ReplayPromise.this.getParent().handleError(e)));
                        e.printStackTrace();
                        solver.resolve(false);
                    }
                });
            }
        });
    }
}

