/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.information;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConferenceInformationHolder {
    private final ConcurrentHashMap<String, ConferenceInformation> mConferenceInformations = new ConcurrentHashMap();

    @Nullable
    public ConferenceInformation getInformation(@Nullable String conferenceId) {
        if (null == conferenceId) {
            return null;
        }
        ConferenceInformation information = null;
        if (this.mConferenceInformations.containsKey(conferenceId)) {
            information = this.mConferenceInformations.get(conferenceId);
        }
        if (null == information) {
            UserService userService = VoxeetSdk.user();
            information = new ConferenceInformation(userService.getUser(), conferenceId);
            this.mConferenceInformations.put(conferenceId, information);
        }
        return information;
    }

    public void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        String previousId = conferenceInformation.getConference().getId();
        conferenceInformation.getConference().setConferenceId(conferenceId);
        this.mConferenceInformations.remove(previousId);
        this.mConferenceInformations.put(conferenceId, conferenceInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConferencesInformation() {
        Log.d((String)"ConferenceService", (String)"clearConferencesInformation: need consensus to what must be done when logging out...");
        ConcurrentHashMap<String, ConferenceInformation> concurrentHashMap = this.mConferenceInformations;
        synchronized (concurrentHashMap) {
            Set<Map.Entry<String, ConferenceInformation>> entries = this.mConferenceInformations.entrySet();
            for (Map.Entry<String, ConferenceInformation> entry : entries) {
                entry.getValue().clean();
            }
            this.mConferenceInformations.clear();
        }
    }
}

