/*
 * Decompiled with CFR 0.152.
 */
package eu.codlab.simplepromise;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.AbstractPromise;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.PromiseDebug;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;

public class PromiseInOut<TYPE, TYPE_RESULT>
extends AbstractPromise<TYPE_RESULT> {
    @Nullable
    private Promise<TYPE_RESULT> mPromise;
    @Nullable
    private PromiseExec<TYPE, TYPE_RESULT> mSimiliPromise;
    private ErrorPromise mSimiliError;
    private PromiseInOut<Object, TYPE> mPromiseInOutParent;
    private PromiseInOut<TYPE_RESULT, Object> mPromiseInOutChild;
    private TYPE mResult;

    private PromiseInOut() {
    }

    PromiseInOut(@NonNull PromiseExec<TYPE, TYPE_RESULT> simili_promise) {
        this();
        this.mSimiliPromise = simili_promise;
    }

    PromiseInOut(@NonNull ErrorPromise simili_promise) {
        this();
        this.mSimiliError = simili_promise;
    }

    PromiseInOut(@NonNull Promise<TYPE_RESULT> promise) {
        this();
        this.mPromise = promise;
    }

    @Override
    public <TYPE_RESULT1> PromiseInOut<TYPE_RESULT, TYPE_RESULT1> then(Promise<TYPE_RESULT1> to_resolve) {
        return this.then(super.then(to_resolve));
    }

    @Override
    public <EXPECTED_TYPE> PromiseInOut<TYPE_RESULT, EXPECTED_TYPE> then(PromiseExec<TYPE_RESULT, EXPECTED_TYPE> next_simili_promise) {
        return this.then(new PromiseInOut<TYPE_RESULT, EXPECTED_TYPE>(next_simili_promise));
    }

    public void error(ErrorPromise error) {
        this.mSimiliError = error;
        this.execute();
    }

    public void execute() {
        PromiseDebug.log("PromiseInOut", "executing promise ----------");
        PromiseDebug.log("PromiseInOut", "having inout parent := " + this.mPromiseInOutParent);
        PromiseDebug.log("PromiseInOut", "having inout parent := " + this.mPromise);
        PromiseDebug.log("PromiseInOut", "executing promise ----------");
        if (null != this.mPromiseInOutParent) {
            this.mPromiseInOutParent.execute();
        } else if (this.mPromise != null) {
            Promise.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    PromiseInOut.this.mPromise.resolve();
                }
            });
        }
    }

    void setParent(PromiseInOut<Object, TYPE> parent) {
        this.mPromiseInOutParent = parent;
    }

    void setChild(PromiseInOut<TYPE_RESULT, Object> child) {
        this.mPromiseInOutChild = child;
    }

    void execute(final Promise promise) {
        Promise.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (promise == PromiseInOut.this.mPromise) {
                    PromiseInOut.this.postAfterOnResult();
                }
            }
        });
    }

    @Override
    private <EXPECTED_TYPE> PromiseInOut<TYPE_RESULT, EXPECTED_TYPE> then(PromiseInOut<TYPE_RESULT, EXPECTED_TYPE> inout) {
        inout.setParent(this);
        this.setChild(inout);
        return inout;
    }

    private void setResult(TYPE result) {
        this.mResult = result;
        this.postAfterOnResult();
    }

    private void postAfterOnError(final Throwable error) {
        if (this.mSimiliError != null) {
            this.mSimiliError.onError(error);
        } else if (this.mPromiseInOutChild != null) {
            Promise.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    PromiseInOut.this.mPromiseInOutChild.postAfterOnError(error);
                }
            });
        }
    }

    private void postAfterOnResult() {
        if (this.mSimiliPromise != null) {
            Promise.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        PromiseInOut.this.mSimiliPromise.onCall(PromiseInOut.this.mResult, new Solver<TYPE_RESULT>(){

                            @Override
                            public <FIRST> void resolve(@NonNull PromiseInOut<FIRST, TYPE_RESULT> promise) {
                                promise.then(new PromiseExec<TYPE_RESULT, Object>(){

                                    @Override
                                    public void onCall(@Nullable TYPE_RESULT result, @NonNull Solver<Object> solver) {
                                        PromiseInOut.this.postResult(result);
                                    }
                                }).error(new ErrorPromise(){

                                    @Override
                                    public void onError(@NonNull Throwable error) {
                                        this.reject(error);
                                    }
                                });
                            }

                            @Override
                            public void resolve(@NonNull Promise<TYPE_RESULT> promise) {
                                promise.then(new PromiseExec<TYPE_RESULT, Object>(){

                                    @Override
                                    public void onCall(@Nullable TYPE_RESULT result, @NonNull Solver<Object> solver) {
                                        this.resolve(result);
                                    }
                                }).error(new ErrorPromise(){

                                    @Override
                                    public void onError(@NonNull Throwable error) {
                                        this.reject(error);
                                    }
                                });
                            }

                            @Override
                            public void resolve(@Nullable TYPE_RESULT result) {
                                if (result instanceof Promise) {
                                    this.resolve((TYPE_RESULT)((Promise)result));
                                } else {
                                    PromiseInOut.this.postResult(result);
                                }
                            }

                            @Override
                            public void reject(@NonNull Throwable error) {
                                PromiseInOut.this.postAfterOnError(error);
                            }
                        });
                    }
                    catch (Exception error) {
                        PromiseInOut.this.postAfterOnError(error);
                    }
                }
            });
        } else if (this.mPromise != null) {
            Promise.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        PromiseInOut.this.mPromise.getSolver().onCall(new Solver<TYPE_RESULT>(){

                            @Override
                            public void resolve(@Nullable TYPE_RESULT result) {
                                PromiseInOut.this.postResult(result);
                            }

                            @Override
                            public <FIRST> void resolve(@NonNull PromiseInOut<FIRST, TYPE_RESULT> promise) {
                                promise.then(new PromiseExec<TYPE_RESULT, Object>(){

                                    @Override
                                    public void onCall(@Nullable TYPE_RESULT result, @NonNull Solver<Object> solver) {
                                        this.resolve(result);
                                    }
                                }).error(new ErrorPromise(){

                                    @Override
                                    public void onError(@NonNull Throwable error) {
                                        this.reject(error);
                                    }
                                });
                            }

                            @Override
                            public void resolve(@NonNull Promise<TYPE_RESULT> promise) {
                                promise.then(new PromiseExec<TYPE_RESULT, Object>(){

                                    @Override
                                    public void onCall(@Nullable TYPE_RESULT result, @NonNull Solver<Object> solver) {
                                        this.resolve(result);
                                    }
                                }).error(new ErrorPromise(){

                                    @Override
                                    public void onError(@NonNull Throwable error) {
                                        this.reject(error);
                                    }
                                });
                            }

                            @Override
                            public void reject(@NonNull Throwable error) {
                                PromiseInOut.this.postAfterOnError(error);
                            }
                        });
                    }
                    catch (Exception e) {
                        PromiseInOut.this.postAfterOnError(e);
                    }
                }
            });
        }
    }

    private void postResult(final TYPE_RESULT result) {
        Promise.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (PromiseInOut.this.mPromiseInOutChild != null) {
                    PromiseInOut.this.mPromiseInOutChild.setResult(result);
                }
            }
        });
    }
}

