/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.utils.FromRestAPI;
import com.voxeet.sdk.utils.InternalEvent;
import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="SocialLogin")
@FromRestAPI
@InternalEvent
public class SocialLoginEvent
extends Event {
    @JsonIgnore
    private final String FB = "FACEBOOK";
    @JsonIgnore
    private final String GOOGLE = "GOOGLE";
    @JsonIgnore
    private final String SLACK = "SLACK";
    @JsonProperty(value="external_network")
    private String externalNetwork;
    private String timezone;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="push_token")
    private String devicePushToken;
    @JsonProperty(value="device_type")
    private String deviceType;
    @JsonProperty(value="device_identifier")
    private String deviceIdentifier;

    public SocialLoginEvent(String externalNetwork, String accessToken, String devicePushToken, String deviceIdentifier) {
        this.externalNetwork = externalNetwork;
        this.timezone = TimeZone.getDefault().getID();
        this.devicePushToken = devicePushToken;
        this.deviceType = "ANDROID";
        this.accessToken = accessToken;
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDevicePushToken() {
        return this.devicePushToken;
    }

    public void setDevicePushToken(String devicePushToken) {
        this.devicePushToken = devicePushToken;
    }

    public String getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getExternalNetwork() {
        return this.externalNetwork;
    }

    public void setExternalNetwork(String externalNetwork) {
        this.externalNetwork = externalNetwork;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public String getType() {
        return "SocialLogin";
    }
}

