/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.SubscribeConferenceErrorEvent;
import com.voxeet.sdk.models.v1.SubscribeConference;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class SubscribeConferenceEventPromiseable
extends AbstractPromiseable<Boolean> {
    public SubscribeConferenceEventPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<SubscribeConference> user = SubscribeConferenceEventPromiseable.this.getProvider().getSubscribeObservable(SubscribeConferenceEventPromiseable.this.getInformation().getConference().getId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<SubscribeConference>(){

                    @Override
                    public void onSuccess(@NonNull SubscribeConference object, @NonNull Response<SubscribeConference> response) {
                        SubscribeConferenceEventPromiseable.this.log("You are no subscribed to this mConference's events");
                        solver.resolve(true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<SubscribeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        SubscribeConferenceEventPromiseable.this.log("Failed to subscribe to this mConference's events");
                        SubscribeConferenceEventPromiseable.this.getEventBus().post((Object)new SubscribeConferenceErrorEvent(SubscribeConferenceEventPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

