/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.Participant;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.models.v2.UserMediaStreamHandler;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Annotate
public class User {
    @NonNull
    private UserMediaStreamHandler streamsHandler;
    @NonNull
    private CopyOnWriteArrayList<MediaStream> streams = new CopyOnWriteArrayList();
    @Nullable
    private String id;
    @Nullable
    private UserInfo userInfo;
    @NonNull
    private ConferenceUserStatus status;
    private String quality;

    private User() {
        this.streamsHandler = new UserMediaStreamHandler(this);
    }

    @NoDocumentation
    public User(@Nullable String id, @Nullable UserInfo userInfo) {
        this();
        this.id = id;
        this.userInfo = userInfo;
    }

    @NoDocumentation
    public User(@NonNull ConferenceUser conferenceUser) {
        this(conferenceUser.getUserId(), conferenceUser.getUserInfo());
        this.updateStatus(conferenceUser.getConferenceStatus());
    }

    @NoDocumentation
    public User(@Nullable UserInfo userInfo) {
        this(null, userInfo);
    }

    @NoDocumentation
    public User(@NonNull Participant participant) {
        this(participant.getParticipantId(), new UserInfo(participant.getName(), participant.getExternalId(), participant.getAvatarUrl()));
    }

    @NoDocumentation
    public User(@NonNull SdkParticipant participant) {
        this(participant.getUserId(), new UserInfo(participant.getMetadata().getExternalName(), participant.getMetadata().getExternalId(), participant.getMetadata().getExternalPhotoUrl()));
        this.updateStatus(ConferenceUserStatus.valueOf(participant.getStatus()));
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @NonNull
    public List<MediaStream> streams() {
        return this.streams;
    }

    @NonNull
    public UserMediaStreamHandler streamsHandler() {
        return this.streamsHandler;
    }

    @NonNull
    public User updateStatus(@NonNull ConferenceUserStatus status) {
        this.status = status;
        return this;
    }

    @NonNull
    public ConferenceUserStatus getStatus() {
        return this.status;
    }

    @NoDocumentation
    public boolean equals(@Nullable Object obj) {
        String externalId;
        if (null == this.id && null == this.userInfo) {
            return false;
        }
        boolean same = false;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConferenceUser) {
            String externalId2;
            ConferenceUser conferenceUser = (ConferenceUser)obj;
            UserInfo conferenceUserInfo = conferenceUser.getUserInfo();
            String string2 = externalId2 = null != this.userInfo ? this.userInfo.getExternalId() : null;
            if (null != this.id) {
                same |= this.id.equals(conferenceUser.getUserId());
            }
            if (null != externalId2 && null != conferenceUserInfo) {
                same |= externalId2.equals(conferenceUserInfo.getExternalId());
            }
        }
        if (obj instanceof Participant) {
            Participant participant = (Participant)obj;
            String string3 = externalId = null != this.userInfo ? this.userInfo.getExternalId() : null;
            if (null != this.id) {
                same |= this.id.equals(participant.getParticipantId());
            }
            if (null != this.id && null != externalId) {
                same |= externalId.equals(participant.getExternalId());
            }
        }
        if (obj instanceof User) {
            User user = (User)obj;
            externalId = null != this.userInfo ? this.userInfo.getExternalId() : null;
            UserInfo other = user.getUserInfo();
            if (null != this.id) {
                same |= this.id.equals(user.getId());
            }
            if (null != this.id && null != externalId && null != other) {
                same |= externalId.equals(other.getExternalId());
            }
        }
        return same;
    }

    @NoDocumentation
    public User setUserInfo(@NonNull UserInfo userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    @Deprecated
    @NoDocumentation
    public void setQuality(@NonNull String quality) {
        this.quality = quality;
    }

    @NoDocumentation
    public void updateIfNeeded(@Nullable String name, @Nullable String avatarUrl) {
        if (null == this.userInfo) {
            this.userInfo = new UserInfo();
        }
        if (!(null == name || null != this.userInfo.getName() && name.equals(this.userInfo.getName()))) {
            this.userInfo.setName(name);
        }
        if (null != avatarUrl && (null == this.userInfo.getAvatarUrl() || avatarUrl.equals(this.userInfo.getAvatarUrl()))) {
            this.userInfo.setAvatarUrl(avatarUrl);
        }
    }

    @NoDocumentation
    @NonNull
    public String toString() {
        return "User{id='" + this.id + '\'' + ", userInfo=" + this.userInfo + ", status=" + (Object)((Object)this.status) + ", quality='" + this.quality + '\'' + '}';
    }
}

