/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.videopresentation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.services.videopresentation.AbstractMediaPlayerProvider;
import com.voxeet.sdk.utils.Annotate;
import java.util.concurrent.CopyOnWriteArrayList;

@Annotate
public class MediaPlayerProviderComponentHolder {
    private static final CopyOnWriteArrayList<AbstractMediaPlayerProvider> MEDIA_PLAYER_PROVIDERS = new CopyOnWriteArrayList();

    private MediaPlayerProviderComponentHolder() {
    }

    public static void register(@NonNull AbstractMediaPlayerProvider mediaPlayerProvider) {
        MEDIA_PLAYER_PROVIDERS.add(mediaPlayerProvider);
    }

    @Nullable
    public static AbstractMediaPlayerProvider getCompatibleMediaPlayerProvider(@NonNull String url) {
        for (AbstractMediaPlayerProvider provider : MEDIA_PLAYER_PROVIDERS) {
            if (!provider.isUrlCompatible(url)) continue;
            return provider;
        }
        return null;
    }
}

