/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.ISdkFilePresentationRService;
import com.voxeet.sdk.core.services.abstracts.AbstractPresentationService;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.json.FileConverted;
import com.voxeet.sdk.json.FilePresentationStarted;
import com.voxeet.sdk.json.FilePresentationStopped;
import com.voxeet.sdk.json.FilePresentationUpdated;
import com.voxeet.sdk.models.v1.FilePresentationConverted;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Annotate
public class SDKFilePresentationService
extends AbstractPresentationService<ISdkFilePresentationRService> {
    private static final String TAG = SDKFilePresentationService.class.getSimpleName();
    private HashMap<String, Solver<FilePresentationConverted>> mCacheSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentationStarted>> mCacheStartedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentationStopped>> mCacheStoppedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentationUpdated>> mCacheUpdatedSolvers = new HashMap();

    @NoDocumentation
    public SDKFilePresentationService(VoxeetSdk instance) {
        super(instance, ISdkFilePresentationRService.class);
        this.registerEventBus();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationStarted event) {
        this.tryUnlock(event.fileId, event, this.mCacheStartedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationStopped event) {
        this.tryUnlock(event.getFileId(), event, this.mCacheStoppedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationUpdated event) {
        this.tryUnlock(event.fileId, event, this.mCacheUpdatedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FileConverted converted) {
        if (null != converted) {
            List<com.voxeet.sdk.models.v1.File> list = converted.getFiles();
            for (com.voxeet.sdk.models.v1.File file : list) {
                Log.d((String)TAG, (String)("onEvent: " + file.getName()));
                String key = this.findSolverFor(file.getName());
                Log.d((String)TAG, (String)("onEvent: " + key));
                if (null == key) continue;
                FilePresentationConverted temp = new FilePresentationConverted(file.getName(), file.getFileId(), file.getSize(), file.getNbImageConverted());
                this.tryUnlock(key, temp, this.mCacheSolvers);
            }
        }
    }

    public String getImage(String fileId, int pageNumber) {
        return String.format(Locale.getDefault(), "%s/v1/files/%s/converted/%d?token=%s", this.getURLRoot(this.getVoxeetSdkInstance()), fileId, pageNumber, this.getInternalJwtToken(this.getVoxeetSdkInstance()));
    }

    public String getThumbnail(String fileId, int pageNumber) {
        return String.format(Locale.getDefault(), "%s/v1/files/%s/converted/%d/thumbnail?token=%s", this.getURLRoot(this.getVoxeetSdkInstance()), fileId, pageNumber, this.getInternalJwtToken(this.getVoxeetSdkInstance()));
    }

    public Promise<FilePresentationConverted> convertFile(final @NonNull File file) {
        return new Promise<FilePresentationConverted>(new PromiseSolver<FilePresentationConverted>(){

            @Override
            public void onCall(final @NonNull Solver<FilePresentationConverted> solver) {
                final String uuid = UUID.randomUUID().toString();
                String appended_name = uuid + file.getName();
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)appended_name, (RequestBody)requestFile);
                ((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).convertFile(requestFile, body).enqueue((Callback)new Callback<ResponseBody>(){

                    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                        if (response.isSuccessful()) {
                            SDKFilePresentationService.this.mCacheSolvers.put(uuid, solver);
                        } else {
                            solver.reject(HttpException.throwResponse(response));
                        }
                    }

                    public void onFailure(Call<ResponseBody> call, Throwable e) {
                        Log.d((String)TAG, (String)("onError: " + e));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @NonNull
    public Promise<FilePresentationStarted> startPresentation(@NonNull FilePresentationConverted body) {
        return this.startPresentation(body, 0);
    }

    @NonNull
    public Promise<FilePresentationStarted> startPresentation(final @NonNull FilePresentationConverted body, final int position) {
        return new Promise<FilePresentationStarted>(new PromiseSolver<FilePresentationStarted>(){

            @Override
            public void onCall(@NonNull Solver<FilePresentationStarted> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(body.getFileId(), body.getName(), position, body.getNbImageConverted());
                SDKFilePresentationService.this.consumeInternalCall(solver, body.getFileId(), SDKFilePresentationService.this.mCacheStartedSolvers, SDKFilePresentationService.this.internalCall((Call<ResponseBody>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).startFilePresentation(SDKFilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @NonNull
    public Promise<FilePresentationStopped> stopPresentation(final @NonNull String fileId) {
        return new Promise<FilePresentationStopped>(new PromiseSolver<FilePresentationStopped>(){

            @Override
            public void onCall(@NonNull Solver<FilePresentationStopped> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId);
                SDKFilePresentationService.this.consumeInternalCall(solver, fileId, SDKFilePresentationService.this.mCacheStoppedSolvers, SDKFilePresentationService.this.internalCall((Call<ResponseBody>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).startFilePresentation(SDKFilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @NonNull
    public Promise<FilePresentationUpdated> updatePresentation(final @NonNull String fileId, final int position) {
        return new Promise<FilePresentationUpdated>(new PromiseSolver<FilePresentationUpdated>(){

            @Override
            public void onCall(@NonNull Solver<FilePresentationUpdated> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId, position);
                SDKFilePresentationService.this.consumeInternalCall(solver, fileId, SDKFilePresentationService.this.mCacheUpdatedSolvers, SDKFilePresentationService.this.internalCall((Call<ResponseBody>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).startFilePresentation(SDKFilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    @Nullable
    private String findSolverFor(@NonNull String name) {
        for (String value : this.mCacheSolvers.keySet()) {
            if (name.indexOf(value) != 0) continue;
            return value;
        }
        return null;
    }
}

