/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.core.services.chat.ChatMessageEvent;
import com.voxeet.sdk.core.services.chat.InternalChatMessage;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.events.sdk.MessageReceived;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v2.ChatMessage;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

@Annotate
public class ChatService
extends AbstractVoxeetService {
    @NoDocumentation
    public ChatService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    @Subscribe
    public void onEvent(MessageReceived event) {
        InternalChatMessage chatMessage = EventsFactory.mapping(event.message, InternalChatMessage.class);
        ConferenceService conferenceService = VoxeetSdk.conference();
        if (null != conferenceService && null != chatMessage) {
            User user = conferenceService.findUserById(chatMessage.ownerId);
            EventBus.getDefault().post((Object)new ChatMessageEvent(user, new ChatMessage(chatMessage)));
        }
    }

    @NonNull
    public Promise<Boolean> sendMessage(@NonNull Conference conference, @NonNull ChatMessage chatMessage) {
        User user;
        InternalChatMessage internalChatMessage;
        String json;
        UserService userService = VoxeetSdk.user();
        ConferenceService conferenceService = VoxeetSdk.conference();
        if (null != userService && null != conferenceService && null != (json = EventsFactory.getJson(internalChatMessage = new InternalChatMessage("Chat_Message", user = new User(userService.getUserId(), userService.getUserInfo()), chatMessage)))) {
            return conferenceService.sendMessage(conference.getId(), json);
        }
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(@NonNull Solver<Boolean> solver) {
                try {
                    throw new IllegalStateException("The sdk is not initialized");
                }
                catch (Exception e) {
                    solver.reject(e);
                    return;
                }
            }
        });
    }
}

