/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.audio.AudioRoute;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.events.sdk.ConferencePreJoinedEvent;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ConferenceEnded;
import com.voxeet.sdk.media.audio.SoundManager;
import com.voxeet.sdk.media.sensors.ConferenceLock;
import com.voxeet.sdk.media.sensors.ProximitySensor;
import com.voxeet.sdk.media.sensors.ScreenSensor;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.AudioType;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.voiceengine.WebRtcAudioUtils;

@Annotate
public class AudioService
extends AbstractVoxeetService {
    private static SoundManager sSoundManager;
    private static final String TAG;
    private List<ConferenceLock> locks = new ArrayList<ConferenceLock>();

    @NoDocumentation
    public AudioService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        AudioService.preInitSounds(instance.getApplicationContext());
        instance.getEventBus().register((Object)this);
        this.locks.add(new ProximitySensor(instance.getApplicationContext()));
        this.locks.add(new ScreenSensor(instance.getApplicationContext()));
    }

    @Nullable
    public static SoundManager getSoundManager() {
        return sSoundManager;
    }

    public static boolean preInitSounds(@NonNull Context applicationContext) {
        if (null == sSoundManager) {
            sSoundManager = new SoundManager(applicationContext);
            return true;
        }
        return false;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferencePreJoinedEvent event) {
        this.enableAec(true);
        this.enableNoiseSuppressor(true);
        this.updateSensors(this.currentRoute());
        sSoundManager.onConferencePreJoinedEvent();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceEnded event) {
        sSoundManager.onConferenceDestroyedPush();
        this.releaseSensors();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        sSoundManager.onConferenceDestroyedPush();
        this.releaseSensors();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return sSoundManager.getAvailableRoutes();
    }

    @NonNull
    public AudioRoute currentRoute() {
        return sSoundManager.currentRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        boolean new_switch = sSoundManager.setAudioRoute(route);
        this.updateSensors(this.currentRoute());
        return new_switch;
    }

    @NonNull
    public AudioService checkOutputRoute() {
        sSoundManager.checkOutputRoute();
        return this;
    }

    public void setSpeakerMode(boolean isSpeaker) {
        sSoundManager.setSpeakerMode(isSpeaker);
        this.updateSensors(this.currentRoute());
    }

    public boolean isBluetoothHeadsetConnected() {
        return sSoundManager.isBluetoothHeadsetConnected();
    }

    public boolean isWiredHeadsetOn() {
        return sSoundManager.isWiredHeadsetOn();
    }

    public boolean isSpeakerOn() {
        return sSoundManager.isSpeakerOn();
    }

    @NonNull
    public AudioService acquireLocks() {
        sSoundManager.acquireLocks();
        return this;
    }

    @NonNull
    public AudioService releaseLocks() {
        sSoundManager.releaseLocks();
        return this;
    }

    @NonNull
    public AudioService resetDefaultSoundType() {
        sSoundManager.resetDefaultSoundType();
        return this;
    }

    @NonNull
    public AudioService abandonAudioFocusRequest() {
        sSoundManager.abandonAudioFocusRequest();
        return this;
    }

    @NonNull
    public AudioService requestAudioFocus() {
        sSoundManager.requestAudioFocus();
        return this;
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return sSoundManager.setSound(type, assetName);
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName, int soundMode) {
        return sSoundManager.setSound(type, assetName, soundMode);
    }

    @NonNull
    public AudioService playSoundType(@NonNull AudioType type) {
        sSoundManager.playSoundType(type);
        return this;
    }

    @NonNull
    public AudioService playSoundType(@NonNull AudioType type, int soundMode) {
        sSoundManager.playSoundType(type, soundMode);
        return this;
    }

    @NonNull
    public AudioService stopSoundType(@NonNull AudioType audioType) {
        sSoundManager.stopSoundType(audioType);
        return this;
    }

    @NonNull
    public AudioService stopSoundType(@NonNull AudioType audioType, int soundMode) {
        sSoundManager.stopSoundType(audioType, soundMode);
        return this;
    }

    @NonNull
    public AudioService stop() {
        sSoundManager.stop();
        return this;
    }

    @NonNull
    public AudioService enable() {
        sSoundManager.enable();
        return this;
    }

    @NonNull
    public AudioService enableMedia() {
        sSoundManager.enableMedia();
        return this;
    }

    @NonNull
    public AudioService unsetMediaRoute() {
        sSoundManager.unsetMediaRoute();
        return this;
    }

    @NonNull
    public AudioService setMediaRoute() {
        sSoundManager.setMediaRoute();
        return this;
    }

    @NonNull
    public AudioService disable() {
        sSoundManager.disable();
        this.stop();
        return this;
    }

    public void updateSensors(@NonNull AudioRoute route) {
        for (ConferenceLock lock : this.locks) {
            if (!route.useProximitySensor() && lock.isProximity()) {
                lock.release();
                continue;
            }
            lock.acquire();
        }
    }

    public void releaseSensors() {
        Log.d((String)"ProximitySensor", (String)"releaseSensors: ");
        for (ConferenceLock lock : this.locks) {
            lock.release();
        }
    }

    public boolean enableAec(boolean enable) {
        WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)enable);
        return true;
    }

    public boolean enableNoiseSuppressor(boolean enable) {
        WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)enable);
        return true;
    }

    static {
        TAG = AudioService.class.getSimpleName();
    }
}

