/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.SessionService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.Participant;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

@Annotate
public class Conference {
    private ReentrantLock lock = new ReentrantLock();
    private static final String TAG = "Conference";
    @NonNull
    private String id;
    @Nullable
    private String alias;
    @NonNull
    private CopyOnWriteArrayList<User> users;
    @Nullable
    private User mixer;
    @Nullable
    private ConferenceInfos conferenceInfos;
    @Nullable
    private RecordingInformation recordingInformation;
    @NonNull
    private ConferenceInformation conferenceInformation;

    private Conference() {
    }

    @NoDocumentation
    public Conference(@NonNull ConferenceInformation conferenceInformation) {
        this.users = new CopyOnWriteArrayList();
        this.id = "";
        this.conferenceInformation = conferenceInformation;
    }

    @NoDocumentation
    public Conference(com.voxeet.sdk.models.v1.Conference fromConference, @NonNull ConferenceInformation conferenceInformation) {
        this();
        this.updateUsers(fromConference.getConferenceUsers());
        this.id = fromConference.getConferenceId();
        this.alias = fromConference.getConferenceAlias();
        this.conferenceInformation = conferenceInformation;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @NonNull
    public CopyOnWriteArrayList<User> getUsers() {
        return this.users;
    }

    public boolean hasAny(ConferenceUserStatus status, boolean local) {
        String id = VoxeetSdk.session().getUserId();
        if (null == id) {
            id = "";
        }
        for (User user : this.users) {
            if (null == user || !status.equals((Object)user.getStatus()) || !local && id.equals(user.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalStreams(boolean includeLocalUser) {
        String id = VoxeetSdk.session().getUserId();
        if (null == id) {
            id = "";
        }
        for (User user : this.users) {
            if (null == user) continue;
            boolean properStatus = ConferenceUserStatus.ON_AIR.equals((Object)user.getStatus());
            if (!(properStatus |= ConferenceUserStatus.CONNECTING.equals((Object)user.getStatus())) || user.streams().size() <= 0 || !includeLocalUser && id.equals(user.getId())) continue;
            return true;
        }
        return false;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUsers(ConferenceUser user) {
        this.lock();
        User internalUser = this.getInternalUserInConference(user);
        if (null == internalUser) {
            this.log("updateUsers: create User from ConferenceUser := " + new User(user));
            this.addUser(new User(user));
        } else {
            internalUser.updateStatus(user.getConferenceStatus());
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUser(@NonNull Participant participant) {
        User internalUser = this.getInternalUserInConference(participant);
        this.lock();
        if (null == internalUser) {
            String externalId = participant.getExternalId();
            User existing = this.findUserByExternalId(externalId);
            if (null != existing) {
                this.log("updateUser: existing user, updating hi\u00b7er");
                existing.updateIfNeeded(participant.getName(), participant.getAvatarUrl());
            } else {
                this.log("updateUser: new user, adding hi\u00b7er, ");
                this.addUser(new User(participant));
            }
        } else {
            internalUser.updateStatus(ConferenceUserStatus.fromString(participant.getStatus()));
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUser(User user) {
        this.lock();
        User internalUser = this.getInternalUserInConference(user);
        if (null == internalUser) {
            this.log("updateUsers: create User from User := " + user);
            this.addUser(user);
        } else {
            internalUser.updateStatus(user.getStatus());
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateUsers(List<ConferenceUser> users) {
        this.lock();
        try {
            for (ConferenceUser user : users) {
                this.updateUsers(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.unlock();
        return this;
    }

    @NoDocumentation
    @NonNull
    public Conference updateParticipants(List<Participant> participants) {
        try {
            for (Participant participant : participants) {
                this.updateUser(participant);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Nullable
    private User getInternalUserInConference(ConferenceUser user) {
        try {
            for (User u : this.users) {
                if (!u.equals(user)) continue;
                return u;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private User getInternalUserInConference(User user) {
        try {
            for (User u : this.users) {
                if (!u.equals(user)) continue;
                return u;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private User getInternalUserInConference(Participant user) {
        try {
            for (User u : this.users) {
                if (!u.equals(user)) continue;
                return u;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @NoDocumentation
    public Conference setConferenceId(@NonNull String id) {
        this.id = id;
        return this;
    }

    @NoDocumentation
    public Conference setConferenceAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public boolean hasMixer() {
        return null != this.mixer && ConferenceUserStatus.ON_AIR.equals((Object)this.mixer.getStatus());
    }

    private boolean isMixer(@NonNull User user) {
        UserInfo userInfo = user.getUserInfo();
        String userName = null != userInfo ? userInfo.getName() : null;
        return null != userName && "Mixer".equalsIgnoreCase(userName.trim());
    }

    @Nullable
    public User findUserById(@Nullable String userId) {
        if (null == userId) {
            return null;
        }
        for (User user : this.users) {
            if (!userId.equals(user.getId())) continue;
            return user;
        }
        SessionService sessionService = VoxeetSdk.session();
        if (null == sessionService) {
            return null;
        }
        String localUserId = sessionService.getUserId();
        if (null != localUserId && localUserId.equals(userId)) {
            Log.d((String)TAG, (String)"findUserById: user not found but local one, creating a TEMP ONE ONLY");
            return sessionService.getUser();
        }
        return null;
    }

    @Nullable
    public User findUserByExternalId(@Nullable String externalId) {
        if (null == externalId) {
            return null;
        }
        for (User user : this.users) {
            UserInfo userInfo = user.getUserInfo();
            if (null == userInfo || !externalId.equals(userInfo.getExternalId())) continue;
            return user;
        }
        return null;
    }

    @NoDocumentation
    public void setConferenceInfos(@NonNull ConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Nullable
    public ConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    @NoDocumentation
    public void setRecordingInformation(@Nullable RecordingInformation recordingInformation) {
        this.recordingInformation = recordingInformation;
    }

    @Nullable
    public RecordingInformation getRecordingInformation() {
        return this.recordingInformation;
    }

    private void addUser(@NonNull User user) {
        this.dumpUsers();
        if (this.isMixer(user)) {
            this.mixer = user;
        } else {
            this.users.add(user);
        }
    }

    private void dumpUsers() {
        String u = "";
        for (User user : this.users) {
            u = u + user.getId() + ",";
        }
        this.log(u);
    }

    public ConferenceState getState() {
        return this.conferenceInformation.getConferenceState();
    }

    private void log(@NonNull String string2) {
        Log.d((String)TAG, (String)("log: " + string2));
    }

    private void lock() {
        try {
            this.lock.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unlock() {
        try {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class RecordingInformation {
        private Date startRecordTimestamp;
        private RecordingStatus recordingStatus;
        private String recordingUser;

        public void setStartRecordTimestamp(Date startRecordTimestamp) {
            this.startRecordTimestamp = startRecordTimestamp;
        }

        public Date getStartRecordTimestamp() {
            return this.startRecordTimestamp;
        }

        public void setRecordingStatus(RecordingStatus recordingStatus) {
            this.recordingStatus = recordingStatus;
        }

        public RecordingStatus getRecordingStatus() {
            return this.recordingStatus;
        }

        public void setRecordingUser(String recordingUser) {
            this.recordingUser = recordingUser;
        }

        public String getRecordingUser() {
            return this.recordingUser;
        }
    }
}

