/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.events.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.events.BaseEvent;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromRestAPI;
import java.util.ArrayList;
import java.util.List;

@Annotate
@FromRestAPI
public class ConferenceStatusResult
extends BaseEvent {
    @Nullable
    public String conferenceId;
    @Nullable
    public String conferenceAlias;
    public long startTimestamp;
    public boolean isLive;
    @Nullable
    public String type;
    @Nullable
    public List<SdkParticipant> participants;

    public List<ConferenceUser> getConferenceUsers() {
        ArrayList<ConferenceUser> users = new ArrayList<ConferenceUser>();
        try {
            if (null != this.participants) {
                for (SdkParticipant participant : this.participants) {
                    ConferenceUser user = new ConferenceUser(participant.getUserId(), null, new UserInfo(participant.getMetadata().getExternalName(), participant.getMetadata().getExternalId(), participant.getMetadata().getExternalPhotoUrl()));
                    user.setConferenceStatusToString(participant.getStatus());
                    user.setStatus(participant.getStatus());
                    user.setConferenceStatus(ConferenceUserStatus.valueOf(participant.getStatus()));
                    users.add(user);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users;
    }

    @Override
    @NonNull
    public String getType() {
        return null != this.type ? this.type : "";
    }
}

