package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;

import java.util.ArrayList;
import java.util.List;

public class ConferenceUtils {

    /**
     * The constant MUTE_FACTOR.
     */
    public static final int MUTE_FACTOR = 10000;

    /**
     * The constant UNMUTE_FACTOR.
     */
    public static final int UNMUTE_FACTOR = 1;


    private ConferenceUtils() {

    }

    @Nullable
    public static ConferenceUser findConferenceUserById(@Nullable final String userId,
                                    @Nullable List<ConferenceUser> users) {
        if(null != users) {
            for (ConferenceUser user : users) {
                if(null != userId && userId.equalsIgnoreCase(user.getUserId())) {
                    return user;
                }
            }
        }
        return null;
    }

    @Nullable
    public static User findUserById(@Nullable final String userId,
                                    @Nullable List<User> users) {
        if(null != users) {
            for (User user : users) {
                if(null != userId && userId.equalsIgnoreCase(user.getId())) {
                    return user;
                }
            }
        }
        return null;
    }

    @NonNull
    public static List<User> findUsersMatching(@Nullable String currentUserOrEmpty, @Nullable List<User> merged_list) {
        List<User> list = new ArrayList<>();
        if(null != currentUserOrEmpty && null != merged_list) {
            for (User user : merged_list) {
                if(null != user && currentUserOrEmpty.equalsIgnoreCase(user.getId())) {
                    list.add(user);
                }
            }
        }
        return list;
    }

    public static List<User> getUserInState(List<User> conferenceUsers, ConferenceUserStatus status) {
        List<User> users = new ArrayList<>();
        for (User user : conferenceUsers) {
            if(null != user && status.equals(user.getStatus())) {
                users.add(user);
            }
        }

        return users;
    }

    public static List<ConferenceUser> getConferenceUserInState(List<ConferenceUser> conferenceUsers, ConferenceUserStatus status) {
        List<ConferenceUser> users = new ArrayList<>();
        for (ConferenceUser user : conferenceUsers) {
            if(null != user && status.equals(user.getConferenceStatus())) {
                users.add(user);
            }
        }

        return users;
    }
}
