package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.ToDelete;

@FromWebsocket
@ToDelete
@Annotate
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.WHISPER_LEFT)
public class WhisperLeft extends Event {

    public String conferenceId;

    public String from;

    @Override
    public String getType() {
        return EventNames.WHISPER_LEFT;
    }
}
