package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.WHISPER_INVITATION_DECLINED)
public class WhisperInvitationDeclined extends Event {

    public String conferenceId;

    public String from;

    @Override
    public String getType() {
        return EventNames.WHISPER_INVITATION_DECLINED;
    }
}
