package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.UPDATE_PROFILE)
public class UpdateProfileEvent extends Event {

    public String userId;

    public String nickName;

    public String firstName;

    public String lastName;

    public String statusPhrase;

    public String company;

    public String jobTitle;

    public String city;

    public String country;

    @Override
    public String getType() {
        return EventNames.UPDATE_PROFILE;
    }
}
