package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromRestAPI;

@FromRestAPI
@Annotate
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.UPDATE_PASSWORD)
public class UpdatePasswordEvent extends Event {

    public String userId;

    public String oldPassword;

    public String newPassword;

    @Override
    public String getType() {
        return EventNames.UPDATE_PASSWORD;
    }
}
