package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

@Annotate
@FromWebsocket
@InternalEvent
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.PEER_CONNECTION_UPDATED)
public class PeerConnectionStatusUpdated extends Event {

    public String userId;

    public String sessionId;

    public String conferenceId;

    public String from;

    public String status;

    @Override
    public String getType() {
        return EventNames.PEER_CONNECTION_UPDATED;
    }
}
