package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.MeetingEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.ToDelete;

@ToDelete
@FromWebsocket
@Annotate
@JsonTypeName(EventNames.MEETING_EVENT_ADDED_OR_UPDATED)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MeetingEventAddedOrUpdatedEvent extends Event {

    private MeetingEvent meetingEvent;

    public MeetingEvent getMeetingEvent() {
        return meetingEvent;
    }

    public void setMeetingEvent(MeetingEvent meetingEvent) {
        this.meetingEvent = meetingEvent;
    }

    @Override
    public String getType() {
        return EventNames.MEETING_EVENT_ADDED_OR_UPDATED;
    }
}
