package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEETING_DELETED)
public class MeetingDeletedEvent extends Event {

    public String meetingId;

    @Override
    public String getType() {
        return EventNames.MEETING_DELETED;
    }
}
