package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Meeting;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

import java.util.List;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEETING_ADDED_OR_UPDATED)
public class MeetingAddedOrUpdatedEvent extends Event {

    public List<Meeting> meetings;

    @Override
    public String getType() {
        return EventNames.MEETING_ADDED_OR_UPDATED;
    }
}
