package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.ScheduleMeeting;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.ToDelete;

@Annotate
@FromWebsocket
@ToDelete
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEET_ACTIVITY_UPDATED)
public class MeetActivityUpdatedEvent extends Event {

    private ScheduleMeeting scheduledConference;

    public ScheduleMeeting getScheduledConference() {
        return scheduledConference;
    }

    public void setScheduledConference(ScheduleMeeting scheduledConference) {
        this.scheduledConference = scheduledConference;
    }

    @Override
    public String getType() {
        return EventNames.MEET_ACTIVITY_UPDATED;
    }
}
