package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.ScheduleMeeting;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.ToDelete;

@Annotate
@ToDelete
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEET_ACTIVITY_ADDED)
public class MeetActivityAddedEvent extends Event {

    @JsonProperty("scheduledConference")
    private ScheduleMeeting meeting;

    public ScheduleMeeting getMeeting() {
        return meeting;
    }

    public void setMeeting(ScheduleMeeting meeting) {
        this.meeting = meeting;
    }

    @Override
    public String getType() {
        return EventNames.MEET_ACTIVITY_ADDED;
    }
}
