package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_STOPPED)
public class FilePresentationStopped extends Event {

    private String conferenceId;

    private String userId;
    private String fileId;

    public FilePresentationStopped() {

    }

    public FilePresentationStopped(String conferenceId,
                                   String userId,
                                   String fileId) {
        this();

        setConferenceId(conferenceId)
                .setUserId(userId)
                .setFileId(fileId);
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public FilePresentationStopped setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
        return this;
    }

    public String setUserId() {
        return userId;
    }

    public FilePresentationStopped setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_STOPPED;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }
}
