package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.UserService;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_STARTED)
public class FilePresentationStarted extends Event {

    public String conferenceId;

    public String userId;

    public int imageCount;

    public String fileId;

    public int position;

    public boolean isOwner() {
        UserService service = VoxeetSdk.user();

        return null != userId && null != service && userId.equals(service.getUserId());
    }

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_STARTED;
    }
}
