package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Contact;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

import java.util.List;

@FromWebsocket
@Annotate
@JsonTypeName(EventNames.CONTACT_ADDED)
public class ContactAdded extends Event {
    public List<Contact> contacts;

    public String externalNetwork;

    @Override
    public String getType() {
        return EventNames.CONTACT_ADDED;
    }
}
