package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;

@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.PARTICIPANT_SWITCH)
public class ConferenceUserSwitch extends Event {

    @JsonProperty("user_id")
    public String userId;

    @JsonProperty("conference_id")
    public String conferenceId;

    @Override
    public String getType() {
        return EventNames.PARTICIPANT_SWITCH;
    }
}
