package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.ToDelete;

@Annotate
@ToDelete
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.BADGE_UPDATE_EVENT)
public class BadgeUpdatedEvent extends Event {

    @JsonProperty("MEETING")
    public String meeting;

    @Override
    public String getType() {
        return EventNames.BADGE_UPDATE_EVENT;
    }
}
