package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.android.media.MediaEngineException;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StopVideoAnswerEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import retrofit2.Call;
import retrofit2.Response;

public class StopVideoPromise extends AbstractPromiseable<Boolean> {
    private final static String TAG = StopVideoPromise.class.getSimpleName();

    public StopVideoPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {

        return new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                try {
                    log("stoppping video");
                    final ConferenceInformation information = getInformation();

                    if (null == information || !getParent().isInConference()) {
                        Log.d(TAG, "stopVideo: not in conf");

                        if (getMediaService().hasMedia()) getMediaService().getMedia().stopVideo();
                        throw new NotInConferenceException();
                    }

                    String conferenceId = information.getConference().getId();

                    if (!getMediaService().hasMedia()) {
                        Log.d(TAG, "stopVideo: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    //Validate.notNull(mConferenceId, "mConference Id");
                    //Validate.notNull(media, "media");

                    //we don't change the video state here since we don't want to override the possible feature of stopping
                    getMediaService().getMedia().stopVideo();

                    final Call<StopVideoResponse> stopVideo = getProvider().getStopVideoObservable(conferenceId, VoxeetPreferences.id());
                    HttpHelper.enqueue(stopVideo, new HttpHelper.HttpCallback<StopVideoResponse>() {
                        @Override
                        public void onSuccess(@NonNull StopVideoResponse object, @NonNull Response<StopVideoResponse> response) {
                            if (getMediaService().hasMedia()) {
                                getMediaService().getMedia().stopVideo();
                            }

                            information.setOwnVideoStarted(false);

                            final StopVideoAnswerEvent event = new StopVideoAnswerEvent(true);
                            getEventBus().post(event);
                            createVideoAnswer(object.userId, object.description, object.candidates)
                                    .then(new PromiseExec<Boolean, Object>() {
                                        @Override
                                        public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                            //TODO check for possible call in the createVideoAnswer (callback ?)
                                            solver.resolve(true);
                                        }
                                    })
                                    .error(new ErrorPromise() {
                                        @Override
                                        public void onError(Throwable error) {
                                            ExceptionManager.sendException(error);
                                            error.printStackTrace();
                                            //TODO check for possible call in the createVideoAnswer (callback ?)
                                            solver.resolve(true);
                                        }
                                    });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable t, @Nullable Response<StopVideoResponse> response) {
                            solver.reject(t);
                        }
                    });
                } catch (MediaEngineException exception) {
                    solver.reject(exception);
                } catch (NotInConferenceException exception) {
                    solver.reject(exception);
                } catch (Exception exception) {
                    solver.reject(exception);
                }
            }
        });
    }
}
