package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.AudioService;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.core.services.conference.information.ConferenceState;
import com.voxeet.sdk.core.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.core.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.models.Conference;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;

public class JoinPromise extends AbstractPromiseable<Boolean> {
    private final static String TAG = JoinPromise.class.getSimpleName();
    private final String conferenceId;
    private final ConferenceUserType userType;
    private final VoxeetSdk instance;
    private AudioService audioService;

    public JoinPromise(@NonNull ConferenceService parent,
                       @NonNull AudioService audioService,
                       @NonNull MediaDeviceService mediaDeviceService,
                       @NonNull ConferenceSdkObservableProvider provider,
                       @Nullable ConferenceInformation information,
                       @NonNull EventBus eventBus,
                       @NonNull VoxeetSdk instance,
                       @NonNull String conferenceId,
                       @NonNull ConferenceUserType userType) {
        super(parent, mediaDeviceService, provider, information, eventBus);

        this.audioService = audioService;
        this.instance = instance;
        this.conferenceId = conferenceId;
        this.userType = userType;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        final Promise<Boolean> promise = new Promise<>(new PromiseSolver<Boolean>() {
            @Override
            public void onCall(@NonNull final Solver<Boolean> solver) {
                //locking
                joinLock();

                //init the conference with the proper conferenceId and alias to null
                ConferenceInformation information = createOrSetConferenceWithParams(conferenceId, null);
                information.setConferenceUserType(userType);

                String currentConferenceId = getParent().getConferenceId();
                ConferenceInformation holder = getConferenceInformation(conferenceId);

                boolean init_done = null != holder &&
                        (ConferenceState.JOINING.equals(holder.getConferenceState())
                                || ConferenceState.JOINED.equals(holder.getConferenceState()));

                if (null != currentConferenceId && currentConferenceId.equals(conferenceId) && init_done) {
                    Log.d(TAG, "onCall: join the conference " + conferenceId + " // invalid call ! already calling it");
                    Log.d(TAG, "onCall: btw, the current " + conferenceId + " state is := " + holder.getConferenceState());

                    solver.resolve(true);
                    joinUnlock();
                    return;
                }

                //prevent issue with the join
                setIsInConference(true);

                Conference conference = holder.getConference();

                Log.d(TAG, "Attempting to join conference alias:=" + conference.getAlias() + " conferenceId:=" + conferenceId);

                Log.d(TAG, "onNext: having conference");

                audioService.enable();

                //TODO wassent here but also after
                //getEventBus().post(new ConferencePreJoinedEvent(conferenceId, conference.getAlias()));

                information.setConferenceState(ConferenceState.JOINING);
                information.setConferenceType(LocalConferenceType.CONFERENCE);
                information.setTelecomMode(getParent().isTelecomMode());

                Log.d(TAG, "onNext: join with := " + conference.getId() + " " + conference.getAlias());

                joinUnlock();

                //fromthe onConferenceCreated deprecated method
                //createOrSetConferenceWithParams(conferenceId, conferenceAlias);
                //getConferenceInformation(conferenceId).setConferenceState(ConferenceState.CREATED);

                //getTwig().i("IConference created with id: " + mConferenceId);

                //mEventBus.post(new ConferenceCreationSuccess(conferenceId, conferenceAlias));

                //TODO the ConferenceCreationSuccess was also sent here
                //TODO check for possibleimprovement ?
                //getEventBus().post(new ConferenceCreationSuccess(conferenceId, conference.getAlias()));

                //set the current conference if none is set in the SDK
                setCurrentConferenceIfNotInPreviousConference(information);

                //try to join the conference
                joinConference(information).then(new PromiseExec<Boolean, Object>() {
                    @Override
                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve(result);
                    }
                }).error(new ErrorPromise() {
                    @Override
                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve(false);
                    }
                });
                //solver.resolve(onConferenceCreated(conference.getConferenceAlias(), conference.getConferenceAlias(), null));


            }
        });

        if (VoxeetSdk.user().isSocketOpen()) {
            return promise;
        } else {
            return new Promise<Boolean>(new PromiseSolver<Boolean>() {
                @Override
                public void onCall(@NonNull final Solver<Boolean> solver) {
                    Log.d(TAG, "onCall: joining but the socket is disconnected");
                    VoxeetSdk.user().login().then(new PromiseExec<Boolean, Object>() {
                        @Override
                        public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                            Log.d(TAG, "onCall: connection ? " + result);
                            promise.then(new PromiseExec<Boolean, Object>() {
                                @Override
                                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                    Log.d(TAG, "onCall: join ok? " + result);
                                    solver.resolve(result);
                                }
                            }).error(new ErrorPromise() {
                                @Override
                                public void onError(@NonNull Throwable error) {
                                    Log.d(TAG, "onError: join ko");
                                    solver.reject(error);
                                }
                            });
                        }
                    }).error(new ErrorPromise() {
                        @Override
                        public void onError(@NonNull Throwable error) {
                            solver.reject(error);
                        }
                    });
                }
            });
        }
    }
}
