package com.voxeet.sdk.core.services.conference.information;

import com.voxeet.sdk.utils.Annotate;

/**
 * Represents the various conference state
 * - default (instantiated)
 * - creating
 * - created
 * - joining
 * - joined
 * - a first participant joined (different than the currently logged in user)
 * - no more participants are in the conference
 * - leaving
 * - left
 */
@Annotate
public enum ConferenceState {
    DEFAULT(true),
    CREATING(true),
    CREATED(true),
    JOINING(true),
    JOINED(true),
    FIRST_PARTICIPANT(true),
    NO_MORE_PARTICIPANT(true),
    LEAVING(false),
    LEFT(false);

    private final boolean mValid;

    ConferenceState(boolean valid) {
        mValid = valid;
    }

    public boolean isValid() {
        return mValid;
    }
}
