package com.voxeet.sdk.core.services.conference.information;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.UserService;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConferenceInformationHolder {
    private final ConcurrentHashMap<String, ConferenceInformation> mConferenceInformations;

    public ConferenceInformationHolder() {
        mConferenceInformations = new ConcurrentHashMap<>();
    }

    @Nullable
    public ConferenceInformation getInformation(@Nullable String conferenceId) {
        if (null == conferenceId) return null;

        ConferenceInformation information = null;

        if (mConferenceInformations.containsKey(conferenceId)) {
            information = mConferenceInformations.get(conferenceId);
        }

        if (null == information) {
            UserService userService = VoxeetSdk.user();

            information = new ConferenceInformation(userService.getUser(), conferenceId);
            mConferenceInformations.put(conferenceId, information);
        }

        return information;
    }

    public void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        String previousId = conferenceInformation.getConference().getId();
        conferenceInformation.getConference().setConferenceId(conferenceId);
        mConferenceInformations.remove(previousId);
        mConferenceInformations.put(conferenceId, conferenceInformation);
    }

    public void clearConferencesInformation() {
        Log.d("ConferenceService", "clearConferencesInformation: need consensus to what must be done when logging out...");
        synchronized (mConferenceInformations) {
            Set<Map.Entry<String, ConferenceInformation>> entries = mConferenceInformations.entrySet();
            for (Map.Entry<String, ConferenceInformation> entry : entries) {
                entry.getValue().clean();
            }

            mConferenceInformations.clear();
        }
    }
}
