package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.events.sdk.ConferenceTimeoutUserJoinedEvent;

import org.greenrobot.eventbus.EventBus;

import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;

public class TimeoutRunnable implements Runnable {

    @NonNull
    private EventBus mEventBus; //initialized with parametered-constructor

    @NonNull
    ConferenceService mService; //initialized with parametered-constructor

    private long mTimeout;
    private boolean mCanceled;
    private boolean mTriggered;

    /**
     * Default constructor, make the runnable "not canceled" by default
     * and triggered is false
     */
    private TimeoutRunnable() {
        setCanceled(false);
        mTriggered = false;
    }

    /**
     * @param service   the service which will be called back
     * @param event_bus the configured event bus
     * @param timeout   the current timeout
     */
    TimeoutRunnable(@NonNull ConferenceService service,
                    @NonNull EventBus event_bus,
                    long timeout) {
        this();

        mService = service;
        mEventBus = event_bus;
        mTimeout = timeout;
    }

    void setCanceled(boolean canceled) {
        mCanceled = canceled;
    }

    private boolean isCanceled() {
        return mCanceled;
    }

    @Override
    public void run() {

        if (!isCanceled()) {
            mService.leave()
                    .then(new PromiseExec() {
                        @Override
                        public void onCall(@Nullable Object o, @NonNull Solver solver) {

                        }
                    })
                    .error(new ErrorPromise() {
                        @Override
                        public void onError(Throwable error) {
                            error.printStackTrace();
                        }
                    });

            //conference was left after Xms
            //note that if you change the timeout after calling the join, the
            //value returned is absolutely inaccurate
            mEventBus.post(new ConferenceTimeoutUserJoinedEvent(mTimeout));
            mTriggered = true;
        }
    }

    boolean isTriggered() {
        return mTriggered;
    }
}
