package com.voxeet.sdk.core.network.endpoints;


import com.voxeet.sdk.core.network.RefreshTokenBody;
import com.voxeet.sdk.json.GrandTypeEvent;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.v1.TokenResponse;
import com.voxeet.sdk.models.v1.UserTokenResponse;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;

public interface IVoxeetRService {

    @POST("v2/users/identify")
    @Headers( {"Content-Type: application/json", "identifying: true"})
    Call<UserTokenResponse> identify(@Body UserInfo info);

    @POST("v1/oauth2/token")
    @Headers("Content-Type: application/json")
    Call<TokenResponse> getToken(@Header("Authorization") String authorization,
                                       @Body GrandTypeEvent grandType);

    @POST("v1/oauth2/refresh")
    @Headers("Content-Type: application/json")
    Call<TokenResponse> refreshToken(@Header("Authorization") String authorization,
                                           @Body RefreshTokenBody body);
}
