/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.models.v2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.MediaStreamType;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.List;

@Annotate
public class UserMediaStreamHandler {
    private User user;

    @NoDocumentation
    public UserMediaStreamHandler(@NonNull User user) {
        this.user = user;
    }

    public boolean has(@NonNull MediaStreamType type) {
        for (MediaStream stream : this.user.streams()) {
            if (!type.equals((Object)stream.getType())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public MediaStream getFirst(@NonNull MediaStreamType type) {
        for (MediaStream stream : this.user.streams()) {
            if (!type.equals((Object)stream.getType())) continue;
            return stream;
        }
        return null;
    }

    @NonNull
    public User insertOrUpdate(@NonNull MediaStream mediaStream) {
        List<MediaStream> streams = this.user.streams();
        boolean found = false;
        for (MediaStream stream : streams) {
            if (!stream.equals((Object)mediaStream)) continue;
            found = true;
            break;
        }
        if (!found) {
            streams.add(mediaStream);
        } else {
            streams.remove(mediaStream);
            streams.add(mediaStream);
        }
        return this.user;
    }

    @NonNull
    public User removeAllStreams() {
        List<MediaStream> streams = this.user.streams();
        streams.clear();
        return this.user;
    }

    @NonNull
    public boolean remove(@NonNull MediaStream mediaStream) {
        List<MediaStream> streams = this.user.streams();
        return streams.remove(mediaStream);
    }

    @NonNull
    public boolean remove(@NonNull MediaStreamType type) {
        List<MediaStream> streams = this.user.streams();
        MediaStream toRemove = null;
        for (MediaStream stream : streams) {
            if (!type.equals((Object)stream.getType())) continue;
            toRemove = stream;
            break;
        }
        if (null != toRemove) {
            streams.remove(toRemove);
            return true;
        }
        return false;
    }
}

