/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.authenticate;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.network.RefreshTokenBody;
import com.voxeet.sdk.core.services.authenticate.token.TokenResponseProvider;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.GrandTypeEvent;
import com.voxeet.sdk.models.v1.TokenResponse;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;
import com.voxeet.sdk.utils.Authentication;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class KeySecretTokenResponseProvider
extends TokenResponseProvider {
    @NonNull
    private String appId = "";
    @NonNull
    private String secret = "";

    private KeySecretTokenResponseProvider(@NonNull AbstractVoxeetEnvironmentHolder holder) {
        super(holder);
    }

    public KeySecretTokenResponseProvider(@NonNull String appId, @NonNull String secret, @NonNull AbstractVoxeetEnvironmentHolder holder) {
        this(holder);
        this.appId = appId;
        this.secret = secret;
    }

    @Override
    @Nullable
    public TokenResponse refreshTokenResponse() {
        Log.d((String)this.TAG, (String)"refreshTokenResponse: calling refreshing token");
        TokenResponse previous = this.tokenResponse;
        TokenResponse new_token_response = null;
        Call<TokenResponse> token = null;
        String tokenizedCredentials = Authentication.basicAuthHeaderValue(this.appId, this.secret);
        try {
            if (null != previous && null != previous.getRefreshToken()) {
                token = this.service.refreshToken(tokenizedCredentials, new RefreshTokenBody(previous.getRefreshToken()));
            }
            if (null != token) {
                new_token_response = (TokenResponse)token.execute().body();
            }
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)("authenticate: error on refresh token " + e.getMessage()));
            ExceptionManager.sendException(e);
            e.printStackTrace();
        }
        if (null != new_token_response && null != new_token_response.getAccessToken()) {
            return new_token_response;
        }
        try {
            token = this.service.getToken(tokenizedCredentials, new GrandTypeEvent("client_credentials"));
            Response response = token.execute();
            TokenResponse body = (TokenResponse)response.body();
            if (null == body || response.code() == 503) {
                try {
                    throw new IllegalStateException("Access refused in callback :: embargoed ?");
                }
                catch (Exception e) {
                    ExceptionManager.sendException(e);
                }
            }
            return body;
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)"refreshTokenResponse: second token attempt error");
            ExceptionManager.sendException(e);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @NonNull
    protected Promise<TokenResponse> retrieveTokenResponse() {
        return new Promise<TokenResponse>(new PromiseSolver<TokenResponse>(){

            @Override
            public void onCall(final @NonNull Solver<TokenResponse> solver) {
                Call<TokenResponse> token = KeySecretTokenResponseProvider.this.service.getToken(Authentication.basicAuthHeaderValue(KeySecretTokenResponseProvider.this.appId, KeySecretTokenResponseProvider.this.secret), new GrandTypeEvent("client_credentials"));
                token.enqueue((Callback)new Callback<TokenResponse>(){

                    public void onResponse(Call<TokenResponse> call, Response<TokenResponse> response) {
                        Log.d((String)KeySecretTokenResponseProvider.this.TAG, (String)("onResponse: " + response.body() + " " + response.code()));
                        if (null != response && response.code() == 503) {
                            try {
                                throw new IllegalStateException("Access refused");
                            }
                            catch (Exception e) {
                                solver.reject(e);
                            }
                        } else {
                            solver.resolve(response.body());
                        }
                    }

                    public void onFailure(Call<TokenResponse> call, Throwable t) {
                        Log.d((String)KeySecretTokenResponseProvider.this.TAG, (String)("onFailure: " + t));
                        t.printStackTrace();
                        solver.reject(t);
                    }
                });
            }
        });
    }

    @Override
    @NonNull
    protected Request.Builder addHeader(@NonNull Request.Builder builder) {
        return builder.addHeader("Authorization", Authentication.basicAuthHeaderValue(this.appId, this.secret));
    }
}

