/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core;

import android.util.Log;
import com.google.gson.Gson;
import com.voxeet.sdk.events.BaseEvent;
import com.voxeet.sdk.events.error.SocketErrorEvent;
import com.voxeet.sdk.events.sdk.MessageReceived;
import com.voxeet.sdk.events.sdk.SocketConnectEvent;
import com.voxeet.sdk.events.sdk.SocketDisconnectEvent;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.events.success.ConferenceUpdated;
import com.voxeet.sdk.events.websocket.RenegociationEndedEvent;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.json.BadgeUpdatedEvent;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ConferenceEnded;
import com.voxeet.sdk.json.ConferenceMessageReceived;
import com.voxeet.sdk.json.ConferenceStats;
import com.voxeet.sdk.json.ConferenceUserSwitch;
import com.voxeet.sdk.json.ContactAdded;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.FileAddedEvent;
import com.voxeet.sdk.json.FileConverted;
import com.voxeet.sdk.json.FileDeletedEvent;
import com.voxeet.sdk.json.FilePresentationStarted;
import com.voxeet.sdk.json.FilePresentationStopped;
import com.voxeet.sdk.json.FilePresentationUpdated;
import com.voxeet.sdk.json.InterfaceEvent;
import com.voxeet.sdk.json.InvitationReceivedEvent;
import com.voxeet.sdk.json.MeetActivityAddedEvent;
import com.voxeet.sdk.json.MeetActivityDeletedEvent;
import com.voxeet.sdk.json.MeetActivityUpdatedEvent;
import com.voxeet.sdk.json.MeetingAddedOrUpdatedEvent;
import com.voxeet.sdk.json.MeetingDeletedEvent;
import com.voxeet.sdk.json.MeetingEventAddedOrUpdatedEvent;
import com.voxeet.sdk.json.MeetingReadTimeStampUpdatedEvent;
import com.voxeet.sdk.json.OfferCreated;
import com.voxeet.sdk.json.OwnConferenceCreated;
import com.voxeet.sdk.json.OwnConferenceUserSwitch;
import com.voxeet.sdk.json.OwnContactRemovedEvent;
import com.voxeet.sdk.json.OwnExternalInvitationSentEvent;
import com.voxeet.sdk.json.OwnProfileUpdated;
import com.voxeet.sdk.json.OwnUserInvited;
import com.voxeet.sdk.json.ParticipantAdded;
import com.voxeet.sdk.json.ParticipantUpdated;
import com.voxeet.sdk.json.PeerConnectionStatusUpdated;
import com.voxeet.sdk.json.PlayEmoSphere;
import com.voxeet.sdk.json.QualityUpdated;
import com.voxeet.sdk.json.RecordingStatusUpdateEvent;
import com.voxeet.sdk.json.TypingDetection;
import com.voxeet.sdk.json.UserInvited;
import com.voxeet.sdk.json.VideoPresentationPaused;
import com.voxeet.sdk.json.VideoPresentationPlay;
import com.voxeet.sdk.json.VideoPresentationSeek;
import com.voxeet.sdk.json.VideoPresentationStarted;
import com.voxeet.sdk.json.VideoPresentationStopped;
import com.voxeet.sdk.json.WhisperInvitationAccepted;
import com.voxeet.sdk.json.WhisperInvitationDeclined;
import com.voxeet.sdk.json.WhisperInvitationReceived;
import com.voxeet.sdk.json.WhisperLeft;
import org.greenrobot.eventbus.EventBus;

public class VoxeetDispatcher {
    private static final String TAG = VoxeetDispatcher.class.getSimpleName();
    private static EventBus eventBus = EventBus.getDefault();

    public static void dispatch(String eventName, String message) {
        Log.d((String)TAG, (String)("dispatch: " + eventName + " := " + message));
        try {
            InterfaceEvent event;
            switch (eventName) {
                case "SOCKET_DISCONNECTED": {
                    event = VoxeetDispatcher.handleDisconnect(message);
                    break;
                }
                case "SOCKET_ERROR": {
                    event = VoxeetDispatcher.handleError(message);
                    break;
                }
                case "SOCKET_TEXT": {
                    event = VoxeetDispatcher.handleMessage(message);
                    break;
                }
                case "SOCKET_CONNECTED": {
                    event = VoxeetDispatcher.handleSocketConnect(message);
                    break;
                }
                case "SOCKET_STATE_CHANGE": {
                    event = VoxeetDispatcher.handleStateChange(message);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown event type");
                }
            }
            eventBus.post((Object)event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BaseEvent handleError(String message) {
        return new SocketErrorEvent(message);
    }

    private static BaseEvent handleDisconnect(String message) {
        return new SocketDisconnectEvent(message);
    }

    private static BaseEvent handleStateChange(String message) {
        return new SocketStateChangeEvent(message);
    }

    private static BaseEvent handleSocketConnect(String message) {
        return new SocketConnectEvent(message);
    }

    private static InterfaceEvent handleMessage(String message) {
        InterfaceEvent busEvent;
        Event event = EventsFactory.decode(message);
        switch (event.getType()) {
            case "OfferCreated": {
                busEvent = (OfferCreated)event;
                break;
            }
            case "ConferenceMessageReceived": {
                busEvent = VoxeetDispatcher.handleConferenceMessage((ConferenceMessageReceived)event);
                break;
            }
            case "ConferenceDestroyedPush": {
                busEvent = (ConferenceDestroyedPush)event;
                break;
            }
            case "ProfileUpdatedEvent": {
                busEvent = event;
                break;
            }
            case "ParticipantUpdated": {
                busEvent = (ParticipantUpdated)event;
                break;
            }
            case "OwnConferenceCreatedEvent": {
                busEvent = (OwnConferenceCreated)event;
                break;
            }
            case "OwnProfileUpdatedEvent": {
                busEvent = (OwnProfileUpdated)event;
                break;
            }
            case "OwnExternalInvitationsSentEvent": {
                busEvent = (OwnExternalInvitationSentEvent)event;
                break;
            }
            case "OwnContactRemovedEvent": {
                busEvent = (OwnContactRemovedEvent)event;
                break;
            }
            case "MeetingAddedOrUpdatedEvent": {
                busEvent = (MeetingAddedOrUpdatedEvent)event;
                break;
            }
            case "MeetingDeletedEvent": {
                busEvent = (MeetingDeletedEvent)event;
                break;
            }
            case "BadgeCounterUpdatedEvent": {
                busEvent = (BadgeUpdatedEvent)event;
                break;
            }
            case "RenegociationEnded": {
                busEvent = (RenegociationEndedEvent)event;
                break;
            }
            case "BroadcastEvent": {
                busEvent = VoxeetDispatcher.handleBroadcast((BroadcastEvent)event);
                break;
            }
            case "RecordingStatusUpdated": {
                busEvent = (RecordingStatusUpdateEvent)event;
                break;
            }
            case "MeetActivityDeletedEvent": {
                busEvent = (MeetActivityDeletedEvent)event;
                break;
            }
            case "MeetActivityUpdatedEvent": {
                busEvent = (MeetActivityUpdatedEvent)event;
                break;
            }
            case "MeetActivityAddedEvent": {
                busEvent = (MeetActivityAddedEvent)event;
                break;
            }
            case "MeetingReadTimestampUpdatedEvent": {
                busEvent = (MeetingReadTimeStampUpdatedEvent)event;
                break;
            }
            case "InvitationReceivedEvent": {
                busEvent = (InvitationReceivedEvent)event;
                break;
            }
            case "MeetingEventAddedOrUpdatedEvent": {
                busEvent = (MeetingEventAddedOrUpdatedEvent)event;
                break;
            }
            case "FileDeletedEvent": {
                busEvent = (FileDeletedEvent)event;
                break;
            }
            case "FileSharedEvent": {
                busEvent = (FileAddedEvent)event;
                break;
            }
            case "QualityUpdated": {
                busEvent = (QualityUpdated)event;
                break;
            }
            case "WhisperInvitationReceivedEvent": {
                busEvent = (WhisperInvitationReceived)event;
                break;
            }
            case "WhisperAcceptedEvent": {
                busEvent = (WhisperInvitationAccepted)event;
                break;
            }
            case "WhisperDeclinedEvent": {
                busEvent = (WhisperInvitationDeclined)event;
                break;
            }
            case "WhisperLeftEvent": {
                busEvent = (WhisperLeft)event;
                break;
            }
            case "OwnUserInvitedEvent": {
                busEvent = (OwnUserInvited)event;
                break;
            }
            case "UserInvited": {
                busEvent = (UserInvited)event;
                break;
            }
            case "ParticipantSwitched": {
                busEvent = (ConferenceUserSwitch)event;
                break;
            }
            case "ParticipantAdded": {
                busEvent = (ParticipantAdded)event;
                break;
            }
            case "OwnParticipantSwitched": {
                busEvent = (OwnConferenceUserSwitch)event;
                break;
            }
            case "ConferenceEndedEvent": {
                busEvent = (ConferenceEnded)event;
                break;
            }
            case "ConferenceStatusUpdated": {
                busEvent = (ConferenceUpdated)event;
                break;
            }
            case "FileConvertedEvent": {
                busEvent = (FileConverted)event;
                break;
            }
            case "FilePresentationStarted": {
                busEvent = (FilePresentationStarted)event;
                break;
            }
            case "FilePresentationStopped": {
                busEvent = (FilePresentationStopped)event;
                break;
            }
            case "FilePresentationUpdated": {
                busEvent = (FilePresentationUpdated)event;
                break;
            }
            case "VideoPresentationStarted": {
                busEvent = (VideoPresentationStarted)event;
                break;
            }
            case "VideoPresentationStopped": {
                busEvent = (VideoPresentationStopped)event;
                break;
            }
            case "VideoPresentationPlay": {
                busEvent = (VideoPresentationPlay)event;
                break;
            }
            case "VideoPresentationPause": {
                busEvent = (VideoPresentationPaused)event;
                break;
            }
            case "VideoPresentationSeek": {
                busEvent = (VideoPresentationSeek)event;
                break;
            }
            case "ContactsAddedEvent": {
                busEvent = (ContactAdded)event;
                break;
            }
            case "PeerConnectionStatusUpdatedEvent": {
                busEvent = (PeerConnectionStatusUpdated)event;
                break;
            }
            case "ConferenceStats": {
                busEvent = (InterfaceEvent)new Gson().fromJson(message, ConferenceStats.class);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type of event");
            }
        }
        return busEvent;
    }

    private static InterfaceEvent handleConferenceMessage(ConferenceMessageReceived event) {
        Event event1 = EventsFactory.decode(event.message);
        if (event1 == null) {
            return new MessageReceived(event.userId, event.conferenceId, event.message);
        }
        switch (event1.getType()) {
            case "VideoPresentationStarted": {
                return (VideoPresentationStarted)event1;
            }
            case "VideoPresentationStopped": {
                return (VideoPresentationStopped)event1;
            }
            case "VideoPresentationPlay": {
                return (VideoPresentationPlay)event1;
            }
            case "VideoPresentationPause": {
                return (VideoPresentationPaused)event1;
            }
            case "VideoPresentationSeek": {
                return (VideoPresentationSeek)event1;
            }
            case "PlayEmosphere": {
                return (PlayEmoSphere)event1;
            }
        }
        return new MessageReceived(event.userId, event.conferenceId, event.message);
    }

    private static InterfaceEvent handleBroadcast(BroadcastEvent event) {
        Event event1 = EventsFactory.decode(event.message);
        switch (event1.getType()) {
            case "TypingDetection": {
                return (TypingDetection)event1;
            }
        }
        throw new IllegalStateException("Unknown broadcast type event");
    }
}

